% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonRho.R
\name{canonRho}
\alias{canonRho}
\title{Generalized canonical correlation, estimating alpha, beta, rho.}
\usage{
canonRho(mtx, nLHS = 2, sgn = 1, verbo = FALSE, ridg = c(0, 0))
}
\arguments{
\item{mtx}{{Input matrix of generalized correlation coefficients R*}}

\item{nLHS}{{number of columns in the LHS set, default=2}}

\item{sgn}{{preferred sign of coefficients default=1 for positive, 
use sgn= -1 if prior knowledge suggests that negative signs of 
coefficients are more realistic}}

\item{verbo}{{logical, verbo=FALSE default means do not print results}}

\item{ridg}{{two regularization constants added 
before computing matrix inverses of S11 and S22, respectively, with
    default=c(0,0). Some suggest ridg=c(0.01,0.01) for stable results}}
}
\value{
\item{A}{eigenvalue computing matrix for Generalized canonical correlations}
\item{rho}{Generalized canonical correlation coefficient}
\item{bet}{RHS coefficient vector}
\item{alp}{LHS coefficient vector}
}
\description{
This function uses data on two sets of column vectors. LHS set [x1, x2 .. xr]
has r=nLHS number of columns 
with coefficients alpha and 
the larger RHS set [xr+1, xr+2, .. xp] has nRHS=(p-r) columns and RHS
coefficients beta.  Must arrange the sets so that the larger set
in on RHS with coefficients beta estimated first from an eigenvector
of the problem A* beta = rho^2 beta where A* is a partitioning of
generalized matrix of (non-symmetric) correlation coefficients.
}
\note{
This function calls \code{\link{kern}},
}
\examples{

\dontrun{
set.seed(99)
mtx2=matrix(sample(1:25),nrow=5)
g1=gmcmtx0(mtx2)
canonRho(g1,verbo=TRUE)
}#' 
}
\references{
Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
Using R', Chapter 4 in 'Handbook of Statistics: Computational Statistics
with R', Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2014, pp. 143-176.

Vinod, H. D. 'Canonical ridge and econometrics of joint production,'
Journal of Econometrics, vol. 4, 147--166.

Vinod, H. D. 'New exogeneity tests and causal paths,'
 Chapter 2 in 'Handbook of Statistics: Conceptual Econometrics 
Using R', Vol.32, co-editors: H. D. Vinod and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2019, pp. 33-64.
}
\seealso{
See  \code{\link{gmcmtx0}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
