% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudoCoefParcor.R
\name{sudoCoefParcor}
\alias{sudoCoefParcor}
\title{Peudo regression coefficients from generalized partial correlation coefficients, 
(GPCC).}
\usage{
sudoCoefParcor(mtx, ctrl = 0, verbo = FALSE, idep = 1)
}
\arguments{
\item{mtx}{{Input data matrix with p (> or = 3) columns},}

\item{ctrl}{{Input vector or matrix of data for control variable(s), 
default is ctrl=0 when control variables are absent}}

\item{verbo}{Make this TRUE for detailed printing of computational steps}

\item{idep}{The column number of the dependent variable (=1, default)}
}
\value{
A p by 1 `out' vector pseudo partial derivatives
}
\description{
This function gets GPCCs by calling  \code{parcorVec} function.
Pseudo regression coefficient of a kernel regression is obtained by
GPCC*(sd dep.var)/(sd regressor), that is
multiplying the GPCC by
the standard deviation (sd) of the dependent variable and dividing by the
sd of the regressor.
}
\note{
Generalized Partial Correlation Coefficients (GPCC) allow comparison of
the relative contribution of each \eqn{X_j} to the explanation of \eqn{X_i},
because GPCC are scale-free pseudo regr coeff are GPCC*(sd dep.var)/(sd regressor)

We want to get all partial
 correlation coefficient pairs removing other column effects. Vinod (2018) 
 shows why one needs more than one criterion to decide the causal paths or exogeneity.
}
\examples{
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10  #x is partly indep and partly affected by z
y=1+2*x+3*z+rnorm(10)# y depends on x and z not vice versa
mtx=cbind(x,y,z)
sudoCoefParcor(mtx, idep=2)
 
   
\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')#some names needed
sudoCoefParcor(x)
}

}
\references{
Vinod, H. D. 'Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark,' (March 8, 2015)
 \url{https://www.ssrn.com/abstract=2574891}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
 Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.

Vinod, H. D. 'New Exogeneity Tests and Causal Paths,' 
(June 30, 2018). Available at SSRN: 
\url{https://www.ssrn.com/abstract=3206096}

Vinod, H. D. (2021) 'Generalized, Partial and Canonical Correlation
Coefficients' Computational Economics, 59(1), 1--28.
}
\seealso{
See Also \code{\link{parcor_ijk}}.

See Also a hybrid version \code{\link{parcorVecH}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\concept{partial correlations}
