% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/44_fun_reg.treemodel.R
\name{reg.treemodel}
\alias{reg.treemodel}
\title{Regression results of terminal nodes from the Pathmox Segmentation Trees}
\usage{
reg.treemodel(
  xtree.reg,
  terminal = TRUE,
  intercept = FALSE,
  label = FALSE,
  label.nodes = NULL,
  ...
)
}
\arguments{
\item{xtree.reg}{An object of class \code{"xtree.reg"} returned by
\code{\link{reg.pathmox}}.}

\item{terminal}{is string, if equal to \code{TRUE}, just the terminal nodes are considered 
for the output reults. when it is equal to \code{FALSE},the regression results are generated 
for all nodes of the tree}

\item{intercept}{if equal to \code{TRUE} also the intercept is considered in the estimation}

\item{label}{is a boolean. tI is false for defect. If it is \code{TRUE}, label.nodes has to be fix.}

\item{label.nodes}{is a vector with the name of the nodes. It is null for defect.}

\item{\dots}{Further arguments passed on to \code{\link{reg.treemodel}}.}
}
\value{
An object of class \code{"regtreemodel"}. Basically a list with the
following results:

\item{inner}{Matrix of the inner relationship between latent variables of the PLS-PM model}

\item{method}{A string containing the used method ("lm" or "lad"}

\item{coefficients}{Matrix coefficients for each terminal node}

\item{Std.}{Matrix of estandard deviation of coefficients for each terminal node}

\item{pval.coef}{Matrix of p-value significance for each terminal node}

\item{r2}{Matrix of r-squared coefficients for each terminal node}
}
\description{
Calculates basic regression results for the terminal nodes of Pathmox Segmentation Trees: liner regression and LAD
trees
}
\details{
The argument \code{xtree.reg} is an object of class \code{"xtree.reg"} returned by 
\code{\link{reg.pathmox}}.
}
\examples{
\dontrun{
#example of LM in alumni satisfaction
 
data(fibtelereg)

#identify the segmentation variables  
segvar= fibtelereg[,2:11]

#select the variables
data.fib= fibtelereg[,12:18]          

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary, 
	levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade, 
	levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade, 
	levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

#regression PATHMOX
fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
			signif=0.05,deep=2,method="lm",size=0.15)

#terminal nodes comparison
fib.node.comp=reg.treemodel(fib.reg.pathmox) 

}

data(fibtelereg)

#identify the segmentation variables  
segvar= fibtelereg[1:50,3:4]

#select the variables
data.fib=fibtelereg[1:50,12:18]          

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=1,method="lm",size=0.15)

fib.node.comp=reg.treemodel(fib.reg.pathmox) 
	
}
\references{
Aluja, T. Lamberti, G. Sanchez, G. (2013). Modeling with heterogeneity. 
Meetings of Italian Statistical Society, Advances in Latent Variables - Methods, 
Models and Applications. Brescia.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.

Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation.
}
\seealso{
\code{\link{pls.pathmox}}
}
\author{
Giuseppe Lamberti
}
