% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geochull.R
\name{geochull}
\alias{geochull}
\title{Convex hull of a set of positions}
\usage{
geochull(lat, lon = NULL)
}
\arguments{
\item{lat,lon}{Position(s) as decimal degrees latitude and longitude.  If
'lat' is 'list' its components 'lat$lat' and 'lat$lon' are used for 'lat'
and 'lon'.}
}
\value{
List with components \code{lat} and \code{lon} of the convex hull of
the input.
}
\description{
Finds the convex hull of a set of positions in lat and lon.
}
\examples{
# draws the convex hull of Iceland's coastline.
geoplot()
geolines(geochull(island))
}
\seealso{
\code{\link{Proj}}, \code{\link{invProj}},
\code{\link[grDevices]{chull}}
}
\keyword{manip}

