% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_urban_area.R
\name{read_urban_area}
\alias{read_urban_area}
\title{Download spatial data of urbanized areas in Brazil}
\usage{
read_urban_area(year = 2015, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{year}{A year number in YYYY format. Defaults to \code{2015}}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function returns
the data set with 'original' resolution or a data set with 'simplified' borders.
Defaults to \code{TRUE}. For spatial analysis and statistics users should set
\code{simplified = FALSE}. Borders have been simplified by removing vertices of
borders using \verb{st_simplify\{sf\}} preserving topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
This function reads the official data on the urban footprint of Brazilian cities
in the years 2005 and 2015. Original data were generated by the Institute of Geography
and Statistics (IBGE)  For more information about the methodology, see details at
\url{https://biblioteca.ibge.gov.br/visualizacao/livros/liv100639.pdf}
}
\examples{
\dontrun{ if (interactive()) {
# Read urban footprint of Brazilian cities in an specific year
d <- read_urban_area(year=2005)
} }
}
