% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_statistical_grid.R
\name{read_statistical_grid}
\alias{read_statistical_grid}
\title{Download spatial data of IBGE's statistical grid}
\usage{
read_statistical_grid(code_grid, year = 2010, showProgress = TRUE)
}
\arguments{
\item{code_grid}{If two-letter abbreviation or two-digit code of a state is
passed, the function will load all grid quadrants that
intersect with that state. If \code{code_grid="all"}, the grid of
the whole country will be loaded. Users may also pass a
grid quadrant id to load an specific quadrant. Quadrant ids
can be consulted at \code{geobr::grid_state_correspondence_table}.}

\item{year}{Year of the data. Defaults to 2010. The only year available thus
far is 2010.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\dontrun{ if (interactive()) {
# Read specific municipality at a given year
grid <- read_statistical_grid(code_grid = 45, year=2010)

# Read all municipalities of a state at a given year
state_grid <- read_statistical_grid(code_grid = "RJ")
}}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
