% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{spiderPlots}
\alias{spiderPlots}
\title{Spider chart}
\usage{
spiderPlots(data, belongmatrix, chartcolors = NULL)
}
\arguments{
\item{data}{A dataframe with numeric columns}

\item{belongmatrix}{A membership matrix}

\item{chartcolors}{A vector of color names used for the spider plot}
}
\value{
NULL, the plots are displayed directly by the function (see fmsb::radarchart)
}
\description{
Display spider charts to quickly compare values between groups
}
\details{
For each group, the weighted mean of each variable in data is calculated
based on the probability of belonging to this group of each observation.
On the chart the exterior ring represents the maximum value obtained for
all the groups and the interior ring the minimum. The groups are located
between these two limits in a linear way.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
spiderPlots(dataset,result$Belongings)
}
