% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_evaluation.R
\name{calcCalinskiHarabasz}
\alias{calcCalinskiHarabasz}
\title{Calinski-Harabasz index}
\usage{
calcCalinskiHarabasz(data, belongmatrix, centers)
}
\arguments{
\item{data}{The original dataframe used for the clustering (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{centers}{The centres of the clusters}
}
\value{
A float: the Calinski-Harabasz index
}
\description{
Calculate the Calinski-Harabasz index of clustering quality.
}
\details{
The Calinski-Harabasz index \insertCite{da2020incremental}{geocmeans} is the ratio between the clusters separation (between groups sum of squares) and the clusters cohesion (within groups sum of squares). A greater
value indicates either more separated clusters or more cohesive clusters.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcCalinskiHarabasz(result$Data, result$Belongings, result$Centers)
}
\references{
\insertAllCited{}
}
