% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingwindow.R
\name{texture_image}
\alias{texture_image}
\title{Calculate Texture Metrics per Pixel}
\usage{
texture_image(
  x,
  window_type = "square",
  size = 5,
  in_meters = FALSE,
  epsg_proj = 5070,
  metric,
  args = NULL,
  parallel = TRUE,
  ncores = NULL,
  nclumps = 100
)
}
\arguments{
\item{x}{A raster or matrix. If a raster is given, it will be projected to
an equal area projection (given by \code{epsg_proj} argument).}

\item{window_type}{Character. Type of window, either circular or square.}

\item{size}{Numeric. Size of window, in number of pixels extra on each side,
or radius (in meters).}

\item{in_meters}{Logical. Is the size given in meters?}

\item{epsg_proj}{Numeric. Appropriate equal area EPSG code used to
crop raster to each circular window.}

\item{metric}{Character. Metric to calculate for each window. Metrics
from the geodiv package are listed below.}

\item{args}{List. Arguments from function to be applied over each window
(e.g., list(threshold = 0.2)).}

\item{parallel}{Logical. Option to run the calculations in
parallel on available cores.}

\item{ncores}{Numeric. If parallel is TRUE, number of cores on which to
run the calculations. Defaults to all available, minus 1.}

\item{nclumps}{Numeric. Number of clumps to split the raster or matrix into.}
}
\value{
A raster or list of rasters (if function results in multiple outputs)
with pixel values representative of the metric value for the window
surrounding that pixel. Note that the raster will always be projected to an
equal area projection because calculations are done on matrices with a
radius of number of pixels.
}
\description{
Calculates the various texture metrics over windows centered
on individual pixels. This creates a continuous surface of the
texture metric.
}
\details{
Metrics available from geodiv package:
\enumerate{
   \item{\code{'sa'}: average surface roughness}
   \item{\code{'sq'}: root mean square roughness}
   \item{\code{'s10z'}: ten-point height}
   \item{\code{'sdq'}: root mean square slope of surface, 2-point method}
   \item{\code{'sdq6'}: root mean square slope of surface, 7-point method}
   \item{\code{'sdr'}: surface area ratio}
   \item{\code{'sbi'}: surface bearing index}
   \item{\code{'sci'}: core fluid retention index}
   \item{\code{'ssk_adj'}: adjusted skewness}
   \item{\code{'ssk'}: skewness}
   \item{\code{'sku_exc'}: excess kurtosis}
   \item{\code{'sku'}: kurtosis}
   \item{\code{'sds'}: summit density}
   \item{\code{'sfd'}: 3d fractal dimension}
   \item{\code{'srw'}: dominant radial wavelength}
   \item{\code{'srwi'}: radial wavelength index}
   \item{\code{'shw'}: mean half wavelength}
   \item{\code{'std'}: angle of dominating texture}
   \item{\code{'stdi'}: texture direction index}
   \item{\code{'svi'}: valley fluid retention index}
   \item{\code{'stxr'}: texture aspect ratio}
   \item{\code{'ssc'}: mean summit curvature}
   \item{\code{'sv'}: maximum valley depth}
   \item{\code{'sph'}: maximum peak height}
   \item{\code{'sk'}: core roughness depth}
   \item{\code{'smean'}: mean peak height}
   \item{\code{'svk'}: reduced valley depth}
   \item{\code{'spk'}: reduced peak height}
   \item{\code{'scl'}: correlation length}
   \item{\code{'sdc'}: bearing area curve height interval}
}
}
\note{
The total window size for square windows will be (size * 2) + 1.
}
\examples{
library(raster)

# import raster image
data(normforest)

# crop raster to much smaller area
x <- crop(normforest, extent(-123, -122.99, 43, 43.01))

# get a surface of root mean square roughness
sa_img <- texture_image(x = x, window = 'square',
size = 11, metric = 'sa',
parallel = FALSE)

# plot the result
plot(sa_img)
}
