% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdq.R
\name{sdq6}
\alias{sdq6}
\title{Root Area Mean Square Slope of Surface}
\usage{
sdq6(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the seven-point root
  mean square slope, Sdq6. The units of the returned value
  are change in z per one unit (pixel).
}
\description{
Calculates the area root mean square slope of a raster or matrix
surface using the seven-point method.
}
\examples{
# import raster image
data(normforest)

# calculate area root mean square slope
Sdq6 <- sdq6(normforest)
}
\references{
This function is based
on the equations found at
https://www.ntmdt-si.ru/data/media/files/manuals/image_analisys_p9_nov12.e.pdf.
}
