% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRaw.r
\name{plotRaw}
\alias{plotRaw}
\title{Plot Raw Data Points}
\usage{
plotRaw(Profile, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(Profile@title, "without topography"), ...)
}
\arguments{
\item{Profile}{profile.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.
This can either be a single character or an integer code for one of a set of graphics symbols.}

\item{...}{plot arguments (like pch, cex, col,...).}
}
\description{
Plots raw data points of a single profile (e.g. to show measurement gaps).
}
\examples{
data(sinkhole) 
plotRaw(sinkhole@profiles[[1]])
plotRaw(sinkhole@profiles[[2]])
plotRaw(sinkhole@profiles[[3]])
}
\seealso{
\code{\link{plotRawHeight}}, \code{\link{RawData-class}}
}

