% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_layer_get_layer.R
\name{get_flat_table}
\alias{get_flat_table}
\alias{get_flat_table.uscb_layer}
\title{Get flat table}
\usage{
get_flat_table(ul, remove_zeros = FALSE, remove_geometry = TRUE)

\method{get_flat_table}{uscb_layer}(ul, remove_zeros = FALSE, remove_geometry = TRUE)
}
\arguments{
\item{ul}{A \code{uscb_layer} object.}

\item{remove_zeros}{A boolean, remove data with zero value.}

\item{remove_geometry}{A boolean, remove geometry column.}
}
\value{
A \code{tibble} object.
}
\description{
Get the layer group data in the form of a flat table that includes all the
available data columns.
}
\details{
Optionally you can delete the rows whose measurement value is zero and remove
the geometry column.
}
\examples{
library(tidyr)

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua \%>\% get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul \%>\% get_layer_names()
# layers[3]
# [1] "X02_RACE"
ul <- ul \%>\% get_layer(layers[3])
lg <- ul \%>\% get_layer_group_names()
# lg[2]
# [1] "003 - DETAILED RACE"
ul <- ul \%>\% get_layer_group(lg[2])

layer <- ul \%>\% get_flat_table()

}
\seealso{


Other result generation functions: 
\code{\link{get_common_flat_table}()},
\code{\link{get_common_geomultistar}()},
\code{\link{get_geomultistar}()}
}
\concept{result generation functions}
