% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{get_areas}
\alias{get_areas}
\alias{get_areas.acs_5yr}
\title{Get area names of a group}
\usage{
get_areas(ac, group)

\method{get_areas}{acs_5yr}(ac, group = NULL)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{group}{A string, area group name.}
}
\value{
A vector, area names.
}
\description{
Gets the names of the Demographic and Economic Areas of a group or set of groups.
}
\details{
If no group is indicated, all available areas are obtained.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

areas <- ac |>
  get_areas(group = "Statistical Areas")

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_groups}()},
\code{\link{get_area_years}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
