% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hotspots_data.R
\name{get_hotspots_data}
\alias{get_hotspots_data}
\title{Download available hot spot data from Serfor's Satellite Monitoring Unit}
\usage{
get_hotspots_data(dsn = NULL, show_progress = TRUE, quiet = FALSE)
}
\arguments{
\item{dsn}{Character. Output filename with the \bold{spatial format}. If missing, a temporary file is created.}

\item{show_progress}{Logical. Suppress bar progress.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
An sf object.
}
\description{
This function allows you to download the latest version of forest fire data available from the Satellite Monitoring Unit of the National Forestry and Wildlife Service of Peru.
For more information, please visit the following website: \url{https://sniffs.serfor.gob.pe/monitoreo/sami/index.html}
}
\examples{
\donttest{
library(geoidep)
library(sf)
hot_spots <- get_hotspots_data(show_progress = FALSE)
head(hot_spots)
}
}
