% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndgeojson.R
\name{ndgeo}
\alias{ndgeo}
\alias{ndgeo_write}
\alias{ndgeo_write.default}
\alias{ndgeo_write.geofeaturecollection}
\alias{ndgeo_write.geofeature}
\alias{ndgeo_read}
\title{Read and write newline-delimited GeoJSON (GeoJSON text sequences)}
\usage{
ndgeo_write(x, file, sep = "\\n")

\method{ndgeo_write}{default}(x, file, sep = "\\n")

\method{ndgeo_write}{geofeaturecollection}(x, file, sep = "\\n")

\method{ndgeo_write}{geofeature}(x, file, sep = "\\n")

ndgeo_read(txt, pagesize = 500, verbose = TRUE)
}
\arguments{
\item{x}{input, an object of class \code{geojson}}

\item{file}{(character) a file. not a connection. required.}

\item{sep}{(character) a character separator to use in \code{\link[=writeLines]{writeLines()}}}

\item{txt}{text, a file, or a url. required.}

\item{pagesize}{(integer) number of lines to read/write from/to the
connection per iteration}

\item{verbose}{(logical) print messages. default: \code{TRUE}}
}
\value{
a \code{geojson} class object
}
\description{
There are various flavors of newline-delimited GeoJSON, all of which
we aim to handle here. See Details for more.
}
\details{
\itemize{
\item \code{ndgeo_write}: writes \pkg{geojson} package types as
newline-delimited GeoJSON to a file
\item \code{ndgeo_read}: reads newline-delimited GeoJSON from a string,
file, or URL into the appropriate geojson type
}

As an alternative to \code{ndgeo_read}, you can simply use
\code{\link[jsonlite:stream_in]{jsonlite::stream_in()}} to convert newline-delimited GeoJSON
to a data.frame
}
\note{
\strong{IMPORTANT}: \code{ngeo_read} for now only handles lines of geojson
in your file that are either features or geometry objects (e.g., point,
multipoint, polygon, multipolygon, linestring, multilinestring)
}
\examples{
# featurecollection
## write
file <- system.file("examples", 'featurecollection2.geojson',
  package = "geojson")
str <- paste0(readLines(file), collapse = " ")
(x <- featurecollection(str))
outfile <- tempfile(fileext = ".geojson")
# fconn <- file(outfile)
ndgeo_write(x, outfile)
fconn <- file(outfile)
readLines(outfile)
jsonlite::stream_in(file(outfile))
## read
ndgeo_read(outfile)
unlink(outfile)

# feature
x <- '{ "type": "Point", "coordinates": [100.0, 0.0] }'
(z <- point(x) \%>\% feature())

# read from an existing file
## GeoJSON objects all of same type: Feature
file <- system.file("examples", 'ndgeojson1.json', package = "geojson")
ndgeo_read(file)
## GeoJSON objects all of same type: Point
file <- system.file("examples", 'ndgeojson2.json', package = "geojson")
ndgeo_read(file)
## GeoJSON objects of mixed type: Point, and Feature
file <- system.file("examples", 'ndgeojson3.json', package = "geojson")
ndgeo_read(file)

\dontrun{
# read from a URL
url <- "https://storage.googleapis.com/osm-extracts.interline.io/honolulu_hawaii.geojsonl"
f <- tempfile(fileext = ".geojsonl")
download.file(url, f)
x <- ndgeo_read(f)
x
unlink(f)

# geojson text sequences from file
file <- system.file("examples", 'featurecollection2.geojson',
  package = "geojson")
str <- paste0(readLines(file), collapse = " ")
x <- featurecollection(str)
outfile <- tempfile(fileext = ".geojson")
ndgeo_write(x, outfile, sep = "\\u001e\\n")
con <- file(outfile)
readLines(con)
close(con)
ndgeo_read(outfile)
unlink(outfile)
}
}
\references{
Newline-delimited JSON has a few flavors.
The only difference between ndjson \url{http://ndjson.org/} and
JSON Lines \url{http://jsonlines.org/} I can tell is that the former
requires UTF-8 encoding, while the latter does not.

GeoJSON text sequences has a specification found at
\url{https://tools.ietf.org/html/rfc8142}. The spec states that:
\itemize{
\item a GeoJSON text sequence is any number of GeoJSON RFC7946 texts
\item each line encoded in UTF-8 RFC3629
\item each line preceded by one ASCII RFC20 record separator (RS; "0x1e")
character
\item each line followed by a line feed (LF)
\item each JSON text MUST contain a single GeoJSON object as defined in RFC7946
}

See also the GeoJSON specification \url{https://tools.ietf.org/html/rfc7946}
}
