% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geojson_read.R
\name{geojson_read}
\alias{geojson_read}
\title{Read geojson from a local file or a URL}
\usage{
geojson_read(x, method = "web", parse = FALSE, ...)
}
\arguments{
\item{x}{Path to a local file or a URL.}

\item{method}{One of web or local. Matches on partial strings.}

\item{parse}{(logical) To parse geojson to data.frame like structures if possible.
Default: \code{FALSE}}

\item{...}{Ignored}
}
\description{
Read geojson from a local file or a URL
}
\details{
Uses \code{\link{file_to_geojson}} internally.
}
\examples{
\dontrun{
# From a file
file <- system.file("examples", "california.geojson", package = "geojsonio")
out <- geojson_read(file)

# From a URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, method = "local")

# Use as.location first if you want
geojson_read(as.location(file))

# use jsonlite to parse to data.frame structures where possible
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, method = "local", parse = TRUE)
}
}

