% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-webgeom-obj.R
\docType{methods}
\name{webgeom}
\alias{webgeom}
\alias{webgeom,ANY-method}
\alias{webgeom,missing-method}
\title{create webgeom object}
\usage{
webgeom(.Object, ...)

\S4method{webgeom}{missing}(.Object, ...)

\S4method{webgeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{webgeom}}

\item{\dots}{additional arguments passed initialize method (e.g., \code{\link{url}}). See 
the named slots above for arguments for \dots}
}
\value{
the webgeom object representing a dataset and parameters
}
\description{
A class representing a web available feature geometry.
}
\details{
slots can be accessed or set with methods of the same names 
(e.g., url(webgeom()))
}
\section{Slots}{

\describe{
\item{\code{url}}{value of type \code{"character"}, the web location for the web feature service}

\item{\code{geom}}{value of type \code{"character"}, the feature for webgeom}

\item{\code{attribute}}{the attribute (e.g., "State")}

\item{\code{values}}{the values of the attribute, (e.g., "Wisconsin") or NA (all)}
}}
\examples{
wg <- webgeom(geom = "sample:CONUS_states", 
 attribute = "STATE",
 values = "New Hampshire")
#-- use available state datasets:
wg <- webgeom('state::New Hampshire')
wg <- webgeom('state::New Hampshire,Wisconsin,Alabama')
#-- use available Level III Ecoregion datasets:
wg <- webgeom('ecoregion::Colorado Plateaus,Driftless Area')
#-- use available simplified HUC8s:
wg <- webgeom('HUC8::09020306,14060009')
wg <- webgeom()
}
\author{
Jordan S Read
}
\seealso{
\code{\link{url}}, \code{\link{geom}}, \code{\link{attribute}}, \code{\link{values}}
}

