% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{create_block_table}
\alias{create_block_table}
\title{Create Block Level Data}
\usage{
create_block_table(
  state,
  county = NULL,
  geometry = TRUE,
  year = 2020,
  mem = FALSE,
  epsg = 3857
)
}
\arguments{
\item{state}{Required. Two letter state postal code.}

\item{county}{Optional. Name of county.  If not provided, returns blocks for the entire state.}

\item{geometry}{Defaults to TRUE. Whether to return the geometry or not.}

\item{year}{year, must be 2000, 2010, or 2020}

\item{mem}{Default is FALSE. Set TRUE to use memoized backend.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
dataframe with data for each block in the selected region. Data includes
2 sets of columns for each race or ethnicity category: population (pop) and
voting age population (vap)
}
\description{
Creates a block level dataset, using the decennial census information, with the
standard redistricting variables.
}
\examples{
\dontrun{
# uses the Census API
create_block_table(state = 'NY', county = 'Rockland', geometry = FALSE)
}
}
\concept{datatable}
