% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOFeatureCatalogueDescription.R
\docType{class}
\name{ISOFeatureCatalogueDescription}
\alias{ISOFeatureCatalogueDescription}
\title{ISOFeatureCatalogueDescription}
\format{\code{\link{R6Class}} object.}
\usage{
ISOFeatureCatalogueDescription
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOFeatureCatalogue
}
\description{
ISOFeatureCatalogueDescription
}
\section{Fields}{

\describe{
\item{\code{complianceCode}}{}

\item{\code{language}}{}

\item{\code{includedWithDataset}}{}

\item{\code{featureCatalogueCitation}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOFeatureCatalogueDescription
 }
 \item{\code{setComplianceCode(compliance)}}{
   Sets the compliance. TRUE if compliant, FALSE otherwise
 }
 \item{\code{addLanguage(lang)}}{
   Adds a language
 }
 \item{\code{delLanguage(lang)}}{
   Deletes a language
 }
 \item{\code{setIncludedWithDataset(include)}}{
   Sets TRUE if included with dataset, FALSE otherwise
 }
 \item{\code{addFeatureCatalogueCitation(citation)}}{
  Adds an object of class \code{ISOCitation} referencing the link
  to Feature Catalogue
 }
 \item{\code{delFeatureCatalogueCitation(citation)}}{
  Deletes an object of class \code{ISOCitation} referencing the link
  to Feature Catalogue
 }
}
}
\examples{
md <- ISOFeatureCatalogueDescription$new()
  md$setComplianceCode(FALSE)
  md$addLanguage("eng")
  md$setIncludedWithDataset(FALSE)

  cit = ISOCitation$new()
  contact = ISOContact$new()
  fcLink <- ISOOnlineResource$new()
  fcLink$setLinkage("http://somelink/featurecatalogue")
  contact$setOnlineResource(fcLink)
  rp = ISOResponsibleParty$new()
  rp$setContactInfo(contact)
  cit$setCitedResponsibleParty(rp)
  md$addFeatureCatalogueCitation(cit)
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{catalogue}
\keyword{description}
\keyword{feature}

