% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOVectorSpatialRepresentation.R
\docType{class}
\name{ISOVectorSpatialRepresentation}
\alias{ISOVectorSpatialRepresentation}
\title{ISOVectorSpatialRepresentation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOVectorSpatialRepresentation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO VectorSpatialRepresentation
}
\description{
ISOVectorSpatialRepresentation
}
\section{Fields}{

\describe{
\item{\code{topologyLevel}}{}

\item{\code{geometricObjects}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOVectorSpatialRepresentation
 }
 \item{\code{setTopologyLevel(topologyLevel)}}{
   Sets the topology level
 }
 \item{\code{addGeometricObject(geometricObjects)}}{
   Adds the geometricObjects
 }
 \item{\code{setGeometricObject(geometricObjects)}}{
   Sets the geometricObjects
 }
 \item{\code{delGeometricObject(geometricObjects)}}{
   Deletes the geometricObjects
 }
}
}
\examples{
md <- ISOVectorSpatialRepresentation$new()
  md$setTopologyLevel("geometryOnly")
  geomObject1 <- ISOGeometricObjects$new()
  geomObject1$setGeometricObjectType("surface")
  geomObject1$setGeometricObjectCount(5L)
  md$addGeometricObjects(geomObject1)
  xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{address}

