# test_ISOResponsibleParty.R
# Author: Emmanuel Blondel <emmanuel.blondel1@gmail.com>
#
# Description: Unit tests for ISOResponsibleParty.R
#=======================
require(geometa, quietly = TRUE)
require(testthat)

context("ISOResponsibleParty")

test_that("encoding",{
  
  #encoding
  md <- ISOResponsibleParty$new()
  md$setIndividualName("someone")
  md$setOrganisationName("somewhere")
  md$setPositionName("someposition")
  md$setRole("pointOfContact")
  
  #add contact
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  md$setContactInfo(contact)
  
  xml <- md$encode()
  expect_is(xml, "XMLInternalNode")
  
  #decoding
  md2 <- ISOResponsibleParty$new(xml = xml)
  xml2 <- md2$encode()
  
  expect_true(ISOAbstractObject$compare(md, md2))
  
})