% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOScope.R
\docType{class}
\name{ISOScope}
\alias{ISOScope}
\title{ISOScope}
\format{\code{\link{R6Class}} object.}
\usage{
ISOScope
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Scope
}
\description{
ISOScope
}
\section{Fields}{

\describe{
\item{\code{level}}{[\code{\link{ISOHierarchyLevel}}] the scope/hierarchy level}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOScope}}
 }
 \item{\code{setLevel(level)}}{
   Sets the scope level, object of class 'character' or \code{\link{ISOHierarchyLevel}}
 }
}
}

\examples{
  md <- ISOScope$new()
  md$setLevel("dataset")
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extent}
