% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOApplicationSchemaInformation.R
\docType{class}
\name{ISOApplicationSchemaInformation}
\alias{ISOApplicationSchemaInformation}
\title{ISOApplicationSchemaInformation}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ApplicationSchemaInformation
}
\description{
ISOApplicationSchemaInformation
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{ISOCitation}}]}

\item{\code{schemaLanguage}}{[\code{\link{character}}]}

\item{\code{constraintLanguage}}{[\code{\link{character}}]}

\item{\code{schemaAscii}}{[\code{\link{character}}]}

\item{\code{graphicsFile}}{[\code{\link{ISOBinary}}]}

\item{\code{softwareDevelopmentFile}}{[\code{\link{ISOBinary}}]}

\item{\code{softwareDevelopmentFileFormat}}{[\code{\link{character}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOApplicationSchemaInformation}}
 }
 \item{\code{setName(name)}}{
   Sets name, object of class \code{\link{ISOCitation}}
 }
 \item{\code{setSchemaLanguage(schemaLanguage)}}{
   Sets schema language
 }
 \item{\code{setConstraintLanguage(constraintLanguage)}}{
   Sets constraint language
 }
 \item{\code{setSchemaAscii(schemaAscii)}}{
   Sets schema Ascii
 }
 \item{\code{setGraphicsFile(graphicsFile)}}{
   Sets graphics file
 }
 \item{\code{setSoftwareDevelopmentFile(file)}}{
   Sets software development file
 }
 \item{\code{setSoftwareDevelopmentFileFormat(format)}}{
   Sets software development file format
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{application}
\keyword{information}
\keyword{schema}
