% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_line.R
\name{gs_line}
\alias{gs_line}
\title{Create a line \code{geom}}
\usage{
gs_line(
  anchor = NULL,
  window = NULL,
  features = 1,
  vertices = NULL,
  sketch = NULL,
  ...
)
}
\arguments{
\item{anchor}{[\code{geom(1)}|\code{data.frame(1)}]\cr Object to derive the
\code{geom} from. It must include column names \code{x}, \code{y} and
optionally a custom \code{fid}.}

\item{window}{[\code{data.frame(1)}]\cr in case the reference window deviates
from the bounding box of \code{anchor} (minimum and maximum values),
specify this here.}

\item{features}{[\code{integerish(1)}]\cr number of lines to create.}

\item{vertices}{[\code{integerish(.)}]\cr number of vertices per line; will
be recycled if it does not have as many elements as specified in
\code{features}.}

\item{sketch}{[\code{raster(1)}]\cr raster object that serves as template to
sketch polygons.}

\item{...}{[various]\cr graphical parameters to \code{\link{gt_locate}}, in
case points are sketched; see \code{\link[grid]{gpar}}}
}
\value{
An invisible \code{geom}.
}
\description{
Create a line geometry (of class \code{\link{geom}}) either by specifying
anchor values or by sketching it.
}
\details{
The arguments \code{anchor} and \code{sketch} indicate how the line
  is created: \itemize{ \item if \code{anchor} is set, the line is created
  parametrically from the given objects' points, \item if an object is set in
  \code{sketch}, this is used to create the \code{geom} interactively, by
  clicking into the plot.}
}
\examples{
# 1. create a line programmatically
coords <- data.frame(x = c(40, 70, 70, 50),
                     y = c(40, 40, 60, 70))

# if no window is set, the bounding box will be set as window
(aGeom <- gs_line(anchor = coords))

# the vertices are plottet relative to the window
library(magrittr)
window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
gs_line(anchor = coords, window = window) \%>\%
  visualise(linecol = "green")

# when a geom is used in 'anchor', its properties are passed on
aGeom <- setWindow(x = aGeom, to = window)
gs_line(anchor = aGeom) \%>\%
  visualise(linecol = "deeppink")
\donttest{
# 2. sketch a line by clicking into a template
gs_line(sketch = gtRasters$continuous, vertices = 4) \%>\%
  visualise(linecol = "orange", linewidth = 5, new = FALSE)
}
}
\seealso{
Other geometry shapes: 
\code{\link{gs_point}()},
\code{\link{gs_polygon}()},
\code{\link{gs_random}()}
}
\concept{geometry shapes}
