% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-net.r, R/stat-net.r
\docType{data}
\name{geom_net}
\alias{GeomNet}
\alias{StatNet}
\alias{geom_net}
\alias{stat_net}
\title{Geom for network visualization within the ggplot2 framework}
\format{An object of class \code{GeomNet} (inherits from \code{Geom}, \code{ggproto}) of length 6.}
\usage{
geom_net(mapping = NULL, data = NULL, stat = "net",
  position = "identity", show.legend = NA, na.rm = TRUE,
  inherit.aes = TRUE, alpha = 0.25, layout = "kamadakawai",
  layout.par = list(), fiteach = FALSE, label = FALSE, ecolour = NULL,
  ealpha = NULL, arrow = NULL, arrowgap = 0.01, directed = FALSE,
  arrowsize = 1, labelcolour = NULL, vertices = NULL, selfies = FALSE,
  ...)

GeomNet

StatNet

stat_net(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  layout = "kamadakawai", layout.par = list(), fiteach = FALSE,
  vertices = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{character string of the network stat corresponding to geom_net.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning. If \code{TRUE} silently removes missing values.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{alpha}{numeric value of alpha blending of vertices.}

\item{layout}{character value specifying the layout algorithm to use. Defaults to "kamadakawai". See \code{?gplot.layout} in the package sna for other choices.}

\item{layout.par}{list of parameters detailing algorithmic specs. Default parameters are used initially. See \code{?gplot.layout} in the package sna for other choices.}

\item{fiteach}{logical value. Should the network be fit in each of the panels separately, or is there going to be one fit for all?}

\item{label}{logical value. Include labels for (all) nodes. labelcolour specifies colour of labels, if they should not be the same as the nodes. labels are taken from the from_id variable, unless a label variable is given.}

\item{ecolour}{colour for edges.}

\item{ealpha}{numeric value of alpha blending of edges.}

\item{arrow}{what kind of arrow should be drawn? See specification of function \code{arrow} in grid package}

\item{arrowgap}{numeric value between 0 and 1 specifying how much (as a proportion of the line length) earlier the line segment should be stopped drawing before reaching the target node. This parameters is only regarded in directed networks.}

\item{directed}{logical value. Should an arrow be drawn from 'from' to 'to' node?}

\item{arrowsize}{numeric value (non-negative). How big should the arrow be drawn? Multiplicative of a pre-specified unit.}

\item{labelcolour}{character of colour for the labels.}

\item{vertices}{data frame containing vertex information. Usage is a bit awkward, because every variable in this data set can only be used with the ggplot2 double dot representation ..varname.. Better: use a joint to include this information in the data dataframe}

\item{selfies}{logical value. Should self-references be shown (by drawing a circle adjacent to the corresponding node)? defaults to FALSE.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}

\item{geom}{The geometric object to use display the data}
}
\value{
A data frame with additional columns:
  \item{x, y}{coordinates of the nodes, beginning of edges,}
  \item{xend, yend}{coordinates end points of edges.}
}
\description{
Geom for network visualization within the ggplot2 framework
}
\examples{
library(ggplot2)
data(blood)
p <- ggplot(data = blood$edges, aes(from_id = from, to_id = to))
p + geom_net(vertices=blood$vertices, aes(colour=..type..)) + theme_net()

bloodnet <- merge(blood$edges, blood$vertices, by.x="from", by.y="label", all=TRUE)
p <- ggplot(data = bloodnet, aes(from_id = from, to_id = to))
p + geom_net()
p + geom_net(aes(colour=rho)) + theme_net()
p + geom_net(aes(colour=rho), label=TRUE, vjust = -0.5)
p + geom_net(aes(colour=rho), label=TRUE, vjust=-0.5, labelcolour="black",
             directed=TRUE, curvature=0.2) + theme_net()
p + geom_net(colour = "orange", layout = 'circle', size = 6)
p + geom_net(colour = "orange", layout = 'circle', size = 6, linewidth=.75)
p + geom_net(colour = "orange", layout = 'circle', size = 0, linewidth=.75,
             directed = TRUE)
p + geom_net(aes(size=Predominance, colour=rho, shape=rho, linetype=group_to),
             linewidth=0.75, label =TRUE, labelcolour="black") +
    facet_wrap(~Ethnicity) +
    scale_colour_brewer(palette="Set2")
ggplot(data = blood$edges, aes(from_id = from, to_id = to)) +
  geom_net(colour = "darkred", layout = "circle", label = TRUE, size = 15,
         directed = TRUE, vjust = 0.5, labelcolour = "grey80",
         arrowsize = 1.5, linewidth = 0.5, arrowgap = 0.05,
         selfies = TRUE, ecolour = "grey40") +
  theme_net()

#Madmen Relationships
data(madmen)
MMnet <- merge(madmen$edges, madmen$vertices, by.x="Name1", by.y="label", all=TRUE)
p <- ggplot(data = MMnet, aes(from_id = Name1, to_id = Name2))
p + geom_net(label=TRUE)
p + geom_net(aes(colour=Gender), size=6, linewidth=1, label=TRUE, fontsize=3, labelcolour="black")
p + geom_net(aes(colour=Gender), size=6, linewidth=1, label=TRUE, labelcolour="black") +
    scale_colour_manual(values=c("#FF69B4", "#0099ff")) + xlim(c(-.05,1.05))
p + geom_net(aes(colour=Gender), size=6, linewidth=1, directed=TRUE, label=TRUE,
             arrowgap=0.01, labelcolour="black") +
    scale_colour_manual(values=c("#FF69B4", "#0099ff")) + xlim(c(-.05,1.05))

p <- ggplot(data = MMnet, aes(from_id = Name1, to_id = Name2))
# alternative labelling: specify label variable.
p + geom_net(aes(colour=Gender, label=Gender), size=6, linewidth=1, fontsize=3,
             labelcolour="black")

## visualizing ggplot2 theme elements
data(theme_elements)
TEnet <- merge(theme_elements$edges, theme_elements$vertices, by.x="parent",
               by.y="name", all=TRUE)
ggplot(data = TEnet, aes(from_id = parent, to_id = child)) +
  geom_net(label=TRUE, vjust=-0.5)


## emails example from VastChallenge 2014
# care has to be taken to make sure that for each panel all nodes are included with
# the necessary information.
# Otherwise line segments show on the plot without nodes.

data(email)
employee <- data.frame(expand.grid(
              label=unique(email$nodes$label), day=unique(email$edges$day)))
employee <- merge(employee, email$nodes, by="label")
emailnet <- merge(subset(email$edges, nrecipients < 54), employee,
                  by.x=c("From", "day"), by.y=c("label", "day"), all=TRUE)

#no facets
ggplot(data = emailnet, aes(from_id = From, to_id = to)) +
  geom_net(aes(colour= CurrentEmploymentType), linewidth=0.5) +
  scale_colour_brewer(palette="Set2")

#facet by day
ggplot(data = emailnet, aes(from_id = From, to_id = to)) +
  geom_net(aes(colour= CurrentEmploymentType), linewidth=0.5, fiteach=TRUE) +
  scale_colour_brewer(palette="Set2") +
  facet_wrap(~day, nrow=2) + theme(legend.position="bottom")
ggplot(data = emailnet, aes(from_id = From, to_id = to)) +
  geom_net(aes(colour= CitizenshipCountry), linewidth=0.5, fiteach=TRUE) +
  scale_colour_brewer(palette="Set2") +
  facet_wrap(~day, nrow=2) + theme(legend.position="bottom")
ggplot(data = emailnet, aes(from_id = From, to_id = to)) +
  geom_net(aes(colour= CurrentEmploymentType), linewidth=0.5, fiteach=FALSE) +
  scale_colour_brewer(palette="Set2") +
  facet_wrap(~day, nrow=2) + theme(legend.position="bottom")

## Les Miserables example

data(lesmis)
lesmisnet <- merge(lesmis$edges, lesmis$vertices, by.x="from", by.y="label", all=TRUE)
p <- ggplot(data=lesmisnet, aes(from_id=from, to_id=to))
p + geom_net(layout="fruchtermanreingold")
p + geom_net(layout="fruchtermanreingold", label=TRUE, vjust=-0.5)
p + geom_net(layout="fruchtermanreingold", label=TRUE, vjust=-0.5, aes(linewidth=degree/5))

## College Football Games in the Fall 2000 regular season
# Source: http://www-personal.umich.edu/~mejn/netdata/
data(football)
ftnet <- merge(football$edges, football$vertices, by.x="from", by.y="label", all=TRUE)
p <- ggplot(data=ftnet, aes(from_id=from, to_id=to))
p + geom_net(aes(colour=value), linewidth=0.75, size=4.5, ecolour="grey80") +
  scale_colour_brewer("Conference", palette="Paired") + theme_net() +
  theme(legend.position="bottom")
}
\keyword{datasets}

