% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.gn}
\alias{plot.gn}
\alias{plot.gnpp}
\alias{plot.gnppfit}
\alias{plot.lppfit}
\title{Plot Methods for Geometric Network related Objects}
\usage{
\method{plot}{gn}(x, ..., title = list(), size = list(), color = list(), frame = FALSE)

\method{plot}{gnpp}(
  x,
  ...,
  title = list(),
  size = list(),
  color = list(),
  shape = 1,
  frame = FALSE,
  covariate = NULL
)

\method{plot}{gnppfit}(
  x,
  ...,
  title = list(),
  size = list(),
  color = list(),
  shape = 1,
  frame = FALSE,
  data = FALSE,
  trans = "identity",
  select = NULL,
  sol = 100
)

\method{plot}{lppfit}(
  x,
  ...,
  title = list(),
  size = list(),
  color = list(),
  shape = 1,
  frame = FALSE,
  data = FALSE,
  trans = "identity",
  sol = 100
)
}
\arguments{
\item{x}{An object which is related to a geometric network
(object of class \code{gn}, \code{gnpp} or \code{gnppfit}).}

\item{...}{Other arguments.}

\item{title}{A named list with names "x", "y" and "plot" which specify the
arguments \code{x}, \code{y} and \code{title} of the
\code{\link[ggplot2]{labs}} function. Each list entry must
be a character vector which has length equal to the number of plots.
The list entries can remain unspecified in which case the respective titles
are left blank.}

\item{size}{A named list with names "lines" and "points" which specify the
\code{size} argument of \code{\link[ggplot2]{geom_segment}} and
\code{\link[ggplot2]{geom_point}}, respectively. Each list entry must be
a numeric vector of length one with positive values. If the whole list or one
entry remains unspecified, default values are used.}

\item{color}{A named list with names "lines" and "points" which specify the
\code{color} argument of \code{\link[ggplot2]{geom_segment}} and
\code{\link[ggplot2]{geom_point}}. Each list entry must specify a valid color.
By default, lines and points are plotted in black.}

\item{frame}{If set to \code{TRUE}, draws a frame around the network and adds
tick marks and axis labeling.}

\item{shape}{The shape used for plotting the points. An integer between 0 and
25. Default to \code{shape = 1} which shows the points as a circle.}

\item{covariate}{Character vector of length one which is name of the
covariate to be plotted. Must be an external categorical covariate with at
most ten different values.}

\item{data}{Set to \code{TRUE} if the data shall be plotted on top of the
fitted intensity.}

\item{trans}{The transformation applied to the color bar of the intensity
fit. Specifies the \code{trans} argument of
\code{\link[ggplot2]{scale_color_gradient}}.}

\item{select}{Allows the plot for a single model term to be selected for
printing. e.g. if just the plot for the second smooth should be printed to
the console, set \code{select = 2}.}

\item{sol}{Solution of the color network plot.}
}
\value{
Invisibly returns an object of class \code{ggplot} or a list
of \code{ggplot} objects.
}
\description{
\code{plot} method for geometric networks, point patterns on geometric
networks, or a fitted point process.
}
