% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-vegetation-indices.R
\name{list_vegetation_indices}
\alias{list_vegetation_indices}
\title{Get comprehensive list of available vegetation indices}
\usage{
list_vegetation_indices(
  category = "all",
  application = "all",
  detailed = FALSE
)
}
\arguments{
\item{category}{Filter by category: "all", "basic", "enhanced", "specialized", "stress"}

\item{application}{Filter by application: "general", "agriculture", "forestry", "stress", "water"}

\item{detailed}{Return detailed information including formulas and references}
}
\value{
Data frame with vegetation index information
}
\description{
Returns detailed information about all 40+ available vegetation indices including
formulas, required bands, applications, and references.
}
\examples{
\donttest{
# All available indices
all_indices <- list_vegetation_indices()

# Only stress detection indices
stress_indices <- list_vegetation_indices(category = "stress")

# Detailed information with formulas
detailed_info <- list_vegetation_indices(detailed = TRUE)

# Agricultural applications only
ag_indices <- list_vegetation_indices(application = "agriculture")
}

}
