% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{prep_icar_data}
\alias{prep_icar_data}
\title{Prepare data for ICAR models}
\source{
Besag, Julian, Jeremy York, and Annie Mollié. 1991. “Bayesian Image Restoration, with Two Applications in Spatial Statistics.” Annals of the Institute of Statistical Mathematics 43 (1): 1–20.

Donegan, Connor. Flexible Functions for ICAR, BYM, and BYM2 Models in Stan. Code Repository. 2021. Available online: \url{https://github.com/ConnorDonegan/Stan-IAR/} (accessed Sept. 10, 2021).

Freni-Sterrantino, Anna, Massimo Ventrucci, and Håvard Rue. 2018. “A Note on Intrinsic Conditional Autoregressive Models for Disconnected Graphs.” Spatial and Spatio-Temporal Epidemiology 26: 25–34.

Morris, Mitzi, Katherine Wheeler-Martin, Dan Simpson, Stephen J Mooney, Andrew Gelman, and Charles DiMaggio. 2019. “Bayesian Hierarchical Spatial Models: Implementing the Besag York Mollié Model in Stan.” Spatial and Spatio-Temporal Epidemiology 31: 100301.

Riebler, Andrea, Sigrunn H Sørbye, Daniel Simpson, and Håvard Rue. 2016. “An Intuitive Bayesian Spatial Model for Disease Mapping That Accounts for Scaling.” Statistical Methods in Medical Research 25 (4): 1145–65.
}
\usage{
prep_icar_data(C, scale_factor = NULL)
}
\arguments{
\item{C}{Connectivity matrix}

\item{scale_factor}{Optional vector of scale factors for each connected portion of the graph structure. If not provided by the user it will be fixed to a vector of ones.}
}
\value{
list of data to add to Stan data list:

\describe{
\item{k}{number of groups}
\item{group_size}{number of nodes per group}
\item{n_edges}{number of connections between nodes (unique pairs only)}
\item{node1}{first node}
\item{node2}{second node. (\code{node1[i]} and \code{node2[i]} form a connected pair)}
\item{weight}{The element \code{C[node1, node2]}.}
\item{group_idx}{indices for each observation belonging each group, ordered by group.}
\item{m}{number of disconnected regions requiring their own intercept.}
\item{A}{n-by-m matrix of dummy variables for the component-specific intercepts.}
\item{inv_sqrt_scale_factor}{By default, this will be a k-length vector of ones. Placeholder for user-specified information. If user provided \code{scale_factor}, then this will be \code{1/sqrt(scale_factor)}.}
\item{comp_id}{n-length vector indicating the group membership of each observation.}
}
}
\description{
Given a symmetric n x n connectivity matrix, prepare data for intrinsic conditional autoregressive models in Stan. This function may be used for building custom ICAR models in Stan. This is used internally by \code{\link[geostan]{stan_icar}}.
}
\details{
This is used internally to prepare data for \code{\link[geostan]{stan_icar}} models. It can also be helpful for fitting custom ICAR models outside of \code{geostan}.
}
\examples{
data(sentencing)
C <- shape2mat(sentencing)
icar.data.list <- prep_icar_data(C)
}
\seealso{
\code{\link[geostan]{edges}}, \code{\link[geostan]{shape2mat}}, \code{\link[geostan]{stan_icar}}, \code{\link[geostan]{prep_car_data}}
}
