% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{row_standardize}
\alias{row_standardize}
\title{Row-standardize a matrix; safe for zero row-sums.}
\usage{
row_standardize(C, warn = TRUE, msg = "Row standardizing connectivity matrix")
}
\arguments{
\item{C}{A matrix}

\item{warn}{Print \code{msg} if \code{warn = TRUE}.}

\item{msg}{A warning message to print.}
}
\value{
A row-standardized matrix, W (i.e., all row sums equal 1, or zero).
}
\description{
Row-standardize a matrix; safe for zero row-sums.
}
\examples{
A <- shape2mat(georgia)
head(Matrix::summary(A))
Matrix::rowSums(A)

W <- row_standardize(A)
head(Matrix::summary(W))
Matrix::rowSums(W)
}
