% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{meuse}
\alias{meuse}
\title{Meuse river data set}
\description{
This data set gives locations and topsoil heavy metal
concentrations, collected in a flood plain of the river Meuse, near
the village of Stein (NL). Heavy metal concentrations are from
composite samples of an area of approximately 15 m x 15 m. This
version of the \code{meuse} dataset is a trimmed down version of
the eponymous dataset from the \code{sp} dataset.
}
\examples{
data(meuse,package='geostats')
semivariogram(x=meuse$x,y=meuse$y,z=log(meuse$cadmium))
}
\keyword{data}
