% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractals.R
\name{cantor}
\alias{cantor}
\title{Cantor set}
\usage{
cantor(n = 5, plot = FALSE, add = FALSE, Y = 0, lty = 1, col = "black", ...)
}
\arguments{
\item{n}{an integer value controling the number of recursive
levels.}

\item{plot}{logical.  If \code{TRUE}, the Cantor set is plotted,
otherwise a list of breaks and counts is returned.}

\item{add}{logical (only used if \code{plot=TRUE}). If
\code{add=FALSE}, then a brand new figure is created; otherwise
the Cantor set is added to an existing plot.}

\item{Y}{y-value for the plot (only used if \code{plot=TRUE}).}

\item{lty}{line type (see \code{pars()} for details)}

\item{col}{colour of the Cantor lines.}

\item{...}{optional arguments to be passed on to \code{matplot} or
\code{matlines}.}
}
\value{
a square matrix with 0s and 1s.
}
\description{
Calculates or plots a Cantor set of fractal lines,
    which is generated using a recursive algorithm that is built on
    a line segment whose middle third is removed. Each level of
    recursion replaces each black line by the same pattern.
}
\examples{
plot(c(0,1),y=c(0,1),type='n',bty='n',ann=FALSE,xaxt='n',yaxt='n',xpd=NA)
cantor(n=0,Y=1.00,plot=TRUE,add=TRUE)
cantor(n=1,Y=0.75,plot=TRUE,add=TRUE)
cantor(n=2,Y=0.50,plot=TRUE,add=TRUE)
cantor(n=3,Y=0.25,plot=TRUE,add=TRUE)
cantor(n=4,Y=0.00,plot=TRUE,add=TRUE)
}
