% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_architecture.R
\docType{class}
\name{RCurve-class}
\alias{RCurve-class}
\title{RCurve Class for defining recruitment distributions}
\description{
This class extends the Curve class, adding recruitment-related quantities such as patient numbers.
}
\section{Slots}{

\describe{
\item{\code{N}}{Total number of patients recruited.}

\item{\code{Nactive}}{Number of patients recruited in active arm. Nactive+Ncontrol=N.}

\item{\code{Ncontrol}}{Number of patients recruited in control arm. Nactive+Ncontrol=N.}

\item{\code{Ratio}}{Randomisation ratio. Nactive divided by Ncontrol = Ratio.}

\item{\code{Length}}{Total length of the recruitment period.}

\item{\code{RF}}{Name of the random generator function describing the Curve.}

\item{\code{paramno}}{Number of parameters required to define the distribution.}

\item{\code{pnames}}{Names of parameters defining the distribution. Should be a vector of length paramno.}

\item{\code{pnames}}{Values of parameters defining the distribution. Should be a list of length paramno.}
}}

\examples{
new("RCurve", type="ExampleCurve",PDF="name_of_pdf_function", CDF="name_of_CDF_function",
RF="name_of_random_draw_function", paramno=2, pnames=c('param1','param2'),pvalue=list(1,2), 
N=100,Nactive=50,Ncontrol=40, Ratio=50/40, Length = 5)
}
\author{
James Bell
}
