% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gestboot.R
\name{gestboot}
\alias{gestboot}
\title{Percentile Based Bootstrap Confidence Intervals}
\usage{
gestboot(
  gestfunc,
  data,
  idvar,
  timevar,
  Yn,
  An,
  Ybin,
  Abin = NA,
  Lny,
  Lnp,
  type = 1,
  Cn = NA,
  LnC = NA,
  cutoff = NA,
  bn = 1000,
  alpha = 0.05,
  onesided = "twosided",
  seed = 123,
  ...
)
}
\arguments{
\item{gestfunc}{Name (without quotations) of the g-estimation function to run.
One of \code{gest}, \code{gestmult}, \code{gestcat} or \code{gestmultcat}.}

\item{data, idvar, timevar, Yn, An, Ybin, Abin, Lny, Lnp, type, Cn, LnC, cutoff}{Same arguments as in gest functions, to be input into gestfunc.}

\item{bn}{Number of bootstrapped datasets.}

\item{alpha}{Confidence level of confidence intervals.}

\item{onesided}{Controls the type of confidence interval generated. Takes one of three inputs, \code{"upper"} for upper one-sided confidence intervals,
\code{"lower"} for lower one-sided confidence intervals, and \code{"twosided"} for two-sided confidence intervals. Defaults to \code{"twosided"}.}

\item{seed}{Integer specifying the random seed for generation of bootstrap samples.}

\item{...}{additional arguments.}
}
\value{
Returns a list of the following four elements.
\item{original }{The value of the causal parameters estimated on the original data \code{data}.}
\item{mean.boot }{The average values of the causal parameters estimated on the bootstrapped datasets.}
\item{conf }{The upper and/or lower bounds of \eqn{1-\alpha} confidence intervals for each element of \eqn{\psi}.
For example, if \code{type=2}, and \eqn{\psi=(\psi_0,\psi_1)}, a separate confidence interval is fitted for \eqn{\psi_0} and \eqn{\psi_1}.}
\item{conf.Bonferroni }{The upper and/or lower bounds of Bonferroni corrected confidence
intervals for \eqn{\psi}, used for multiple comparisons.}
}
\description{
Generates percentile based confidence intervals for the causal parameters
of a fitted SNMM. Bonferroni corrected confidence
intervals are also reported for multiple comparisons.
}
\examples{
datas<-dataexamples(n=500,seed=123,Censoring=FALSE)
data=datas$datagest
idvar="id"
timevar="time"
Yn="Y"
An="A"
Ybin=FALSE
Abin=TRUE
Lny=c("L","U")
Lnp=c("L","U")
gestfunc<-gest
type=2
bn=5
alpha=0.05
Cn<-NA
LnC<-NA
gestboot(gest,data,idvar,timevar,Yn,An,Ybin,Abin,Lny,
Lnp,type=1,bn=bn,alpha=alpha,onesided="twosided",seed=123)

}
