% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_getLogs}
\alias{eth_getLogs}
\title{New filter and its logs.}
\usage{
eth_getLogs(from_block = "earliest", to_block = "latest", address,
  topics = -1, block_hash = -1)
}
\arguments{
\item{from_block}{Integer|Tag - Block number, or the string 'earliest',
'latest' or 'pending'.}

\item{to_block}{Integer|Tag - Block number, or the string 'earliest',
'latest' or 'pending'.}

\item{address}{Address - Contract address or a list of addresses from which
logs should originate.}

\item{topics}{Array of Data - Topics are order-dependent. Each topic can also
be an array of DATA with 'or' options.}

\item{block_hash}{Hash Single block to return logs. If \code{blockHash} is
present in the filter criteria, then neither \code{fromBlock} nor
\code{toBlock} are allowed.}
}
\value{
Hash - A filter Id.
}
\description{
\code{eth_getLogs} returns an array of all logs matching a given filter
object.
}
\examples{
\donttest{
eth_getLogs(0, 100, '0xcaf9a0356ddfa779fdbb55c45b22d35673550f30',
list('0x977f31fe2eae427d123315e068c90016b9f8c44b9c8d0818a740f06d2dc10f95',
'0x0000000000000000000000000000000000000000000000000000000000000003'))
eth_getLogs(address = '0x8655bd257db96eb2aca7154f845d6b1d67689219')
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}}, \code{\link{eth_call}},
  \code{\link{eth_coinbase}},
  \code{\link{eth_estimateGas}},
  \code{\link{eth_gasPrice}}, \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getProof}},
  \code{\link{eth_getStorageAt}},
  \code{\link{eth_getTransactionByBlockHashAndIndex}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleByBlockNumberAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
