% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{rMedian_UCL}
\alias{rMedian_UCL}
\title{Median of Subgroup Ranges Upper Control Limit (UCL)}
\usage{
rMedian_UCL(data = data, value = value, grouping = grouping,
  formula = NULL, ...)
}
\arguments{
\item{data}{data frame to be processed}

\item{value}{numeric vector in a data frame with values of interest.}

\item{grouping}{single factor/variable to split the data frame "values" by.}

\item{formula}{a formula, such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A number; median of subgroup range upper control limit (UCL).
}
\description{
Calculates the median of subgroup range upper control limit
 (UCL) used when constructing a xBar_rMedian chart.
}
\examples{
set.seed(5555)
df <- data.frame(v=rnorm(60, 0, 1), g=rep(c("A","B","C","D","E"), each=12))
rMedian_UCL(data = df, formula = v~g)
}
