% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/print.gg_rfsrc.R
\name{print.gg_rfsrc}
\alias{print.gg_rfsrc}
\title{Print a \code{\link{gg_rfsrc}} object.}
\usage{
\method{print}{gg_rfsrc}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_rfsrc}} object.}

\item{...}{optional arguments}
}
\description{
Print a \code{\link{gg_rfsrc}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(rfsrc_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_rfsrc(rfsrc_iris)
print(gg_dta)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
# ... or load a cached randomForestSRC object
data(rfsrc_airq, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_rfsrc(rfsrc_airq)
print(gg_dta)

# To nicely print a rfsrc output...
print.gg_rfsrc(rfsrc_airq)
}

