% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_error.R
\name{gg_error}
\alias{gg_error}
\alias{gg_error.randomForest}
\alias{gg_error.randomForest.formula}
\alias{gg_error.rfsrc}
\title{randomForestSRC error rate data object}
\usage{
gg_error(object, ...)
}
\arguments{
\item{object}{\code{\link[randomForestSRC]{rfsrc}} object.}

\item{...}{optional arguments (not used).}
}
\value{
\code{gg_error} \code{data.frame} with one column indicating the tree number,
and the remaining columns from the \code{\link[randomForestSRC]{rfsrc}$err.rate} return value.
}
\description{
Extract the cumulative (OOB) \code{randomForestSRC} error rate as a function of
number of trees.
}
\details{
The \code{gg_error} function simply returns the
\code{\link[randomForestSRC]{rfsrc}$err.rate} object as a data.frame, and assigns the class
for connecting to the S3 \code{\link{plot.gg_error}} function.
}
\examples{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## ------------- iris data
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# ... or load a cached randomForestSRC object
data(rfsrc_iris, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_error(rfsrc_iris)

# Plot the gg_error object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
\dontrun{
## ------------- airq data
rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")

# Get a data.frame containing error rates
gg_dta<- gg_error(rfsrc_airq)

# Plot the gg_error object
plot(gg_dta)
}

## ------------- Boston data
data(rfsrc_Boston, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_error(rfsrc_Boston)

# Plot the gg_error object
plot(gg_dta)

\dontrun{
## ------------- mtcars data

# Get a data.frame containing error rates
gg_dta<- gg_error(rfsrc_mtcars)

# Plot the gg_error object
plot(gg_dta)
}

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
\dontrun{
## ------------- veteran data
## randomized trial of two treatment regimens for lung cancer
data(veteran, package = "randomForestSRC")
rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = dta$veteran, ...)

gg_dta <- gg_error(rfsrc_veteran)
plot(gg_dta)
}

## ------------- pbc data
# Load a cached randomForestSRC object
data(rfsrc_pbc, package="ggRandomForests")

gg_dta <- gg_error(rfsrc_pbc)
plot(gg_dta)

}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R, Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, Regression
and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{plot.gg_error}} \code{rfsrc} \code{plot.rfsrc}
}

