% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_textp.r
\name{annotate_textp}
\alias{annotate_textp}
\title{Text annotations in plot coordinate system}
\usage{
annotate_textp(label, x, y, facets = NULL, hjust = 0, vjust = 0,
  color = "black", alpha = NA, family = theme_get()$text$family,
  size = theme_get()$text$size, fontface = 1, lineheight = 1,
  box_just = ifelse(c(x, y) < 0.5, 0, 1), margin = unit(size/2, "pt"))
}
\arguments{
\item{label}{text annotation to be placed on the plot}

\item{x, y}{positions of the individual annotations, in plot coordinates
(0..1) instead of data coordinates!}

\item{facets}{facet positions of the individual annotations}

\item{hjust, vjust}{horizontal and vertical justification of the text relative
to the bounding box}

\item{color, }{alpha, family, size, fontface, lineheight font properties}

\item{alpha, family, size, fontface, lineheight}{standard aesthetic customizations}

\item{box_just}{placement of the bounding box for the text relative to x,y
coordinates. Per default, the box is placed to the center of the plot. Be
aware that parts of the box which are outside of the visible region of the
plot will not be shown.}

\item{margin}{margins of the bounding box}
}
\description{
Annotates the plot with text. Compared to \code{annotate("text",...)}, the
placement of the annotations is specified in plot coordinates (from 0 to 1)
instead of data coordinates.
}
\examples{
p <- ggplot(mtcars, aes(x = wt, y = mpg)) + geom_point()
p <- p + geom_smooth(method = "lm", se = FALSE)
p + annotate_textp(x = 0.9, y = 0.35, label="A relative linear\\nrelationship", hjust=1, color="red")
}
