% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-trail.R
\name{shadow_trail}
\alias{shadow_trail}
\title{A trail of evenly spaced old frames}
\usage{
shadow_trail(distance = 0.05, max_frames = Inf, ...,
  exclude_layer = NULL)
}
\arguments{
\item{distance}{The temporal distance between the frames to show, as a
fraction of the full animation length}

\item{max_frames}{The maximum number of shadow frames to show}

\item{...}{changes to the shadow data, e.g. \code{alpha = alpha/2} or
\code{colour = 'grey'}}

\item{exclude_layer}{Indexes of layers that should be excluded.}
}
\description{
This shadow will trace the movement in your animation by keeping every \emph{n}th
frame and will thus produce a breadcrumb-like trail. Note that the shadow
frames will not be equidistant in space but in time (that is, if a point
moves slowly the \emph{crumbs} will be closer to each other). It is possible to
modify the look of the shadow by changing the different graphic parameters in
the data
}
\examples{
anim <- ggplot(airquality, aes(Day, Temp, colour = factor(Month))) +
  geom_point() +
  transition_time(Day)

# Change distance between points
anim1 <- anim +
  shadow_trail(0.02)

# Style shadow differently
anim2 <- anim +
  shadow_trail(alpha = 0.3, shape = 2)

# Restrict the shadow to 10 frames
anim3 <- anim +
  shadow_trail(max_frames = 10)

}
\seealso{
Other shadows: \code{\link{shadow_mark}},
  \code{\link{shadow_null}}, \code{\link{shadow_wake}}
}
\concept{shadows}
