% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_elements.R
\name{element_arrow}
\alias{element_arrow}
\title{Arrow theme element}
\usage{
element_arrow(
  colour = NULL,
  linewidth = NULL,
  linewidth_head = NULL,
  linewidth_fins = NULL,
  stroke_colour = NULL,
  stroke_width = NULL,
  arrow_head = NULL,
  arrow_fins = NULL,
  arrow_mid = NULL,
  length = NULL,
  length_head = NULL,
  length_fins = NULL,
  length_mid = NULL,
  resect = NULL,
  resect_head = NULL,
  resect_fins = NULL,
  justify = NULL,
  force_arrow = NULL,
  mid_place = NULL,
  lineend = NULL,
  linejoin = NULL,
  linemitre = NULL,
  inherit.blank = FALSE
)
}
\arguments{
\item{colour}{The colour of the arrow.}

\item{linewidth, linewidth_head, linewidth_fins}{The width of the arrow shaft
in millimetres. \code{linewidth} is the default width, whereas \code{linewidth_head}
and \code{linewidth_fins} can set non-uniform width at the end and start of the
line respectively.}

\item{stroke_colour}{The colour of the arrow outline.}

\item{stroke_width}{The width of the arrow outlien.}

\item{arrow_head, arrow_fins, arrow_mid}{Arrow
\link[=arrow_ornaments]{ornament shapes} for the arrow head, arrow fins and
middle arrows respectively. Can be one of the following:
* \code{NULL} for not drawing the ornament.
* A \verb{<character>} of length 1 naming an ornament constructor without the
\code{"arrow_"}-prefix, like \code{"head_wings"} or \code{"fins_feather"}.
* A 2-column matrix, such as those built by the
\link[=arrow_ornaments]{ornament constructors}.}

\item{length, length_head, length_fins, length_mid}{Determines the size of
the arrow ornaments. \code{length} sets the default length, whereas
\code{length_head}, \code{length_fins} and \code{length_mid} set the lengths of the
arrow head, arrow fins or middle arrows respectively. Can be one of the
following:
\itemize{
\item A \verb{<numeric>} to set the ornament size relative to the \verb{linewidth\{_\\*\}}
settings.
\item A \code{\link[grid:unit]{<unit>}} to control the ornament size in an absolute
manner. Behaviour of relative units such as \code{"npc"} or \code{"null"} is
undefined.
}}

\item{resect, resect_head, resect_fins}{A \code{numeric(1)} denoting millimetres
or \code{\link[grid:unit]{<unit>}} to set an offset from the start and end points
of the line such that the arrow is shortened. \code{resect} sets the default
offset, whereas \code{resect_head} and \code{resect_fins} sets these offsets for the
end- and start-point respectively.}

\item{justify}{A \code{numeric(1)} between [0-1] to control where the arrow
ornaments should be drawn relative to the (resected) path's endpoints.
A value of \code{0} (default) sets the ornament's tips at the path's endpoint,
whereas a value of \code{1} sets the ornament's base at the path's endpoint.}

\item{force_arrow}{A \code{logical(1)} which if \code{TRUE}, will draw arrow ornaments
even when the path's length is shorter than the arrow heads and fins.
If \code{FALSE}, such ornaments will be dropped.}

\item{mid_place}{Sets the location of middle (interior) ornaments when
\code{arrow_mid} has been provided. Can be one of the following:
\itemize{
\item A \verb{<numeric>} vector with values between [0-1] to set middle ornaments
at relative positions along the arc-length of the (resected) path.
\item A \code{\link[grid:unit]{<unit>}} to fill a path with ornaments with th provided
unit as spacing between one ornament to the next.
}}

\item{lineend}{A \code{character(1)} setting the style of the line ends without
ornaments. Can be \code{"round"}, \code{"butt"} or \code{"square"}.}

\item{linejoin}{A \code{character(1)} setting the style of path corners. Can be
\code{"round"}, \code{"mitre"} or \code{"bevel"}.}

\item{linemitre}{A \code{numeric(1)} greater than 1 setting the path's mitre
limits.}

\item{inherit.blank}{A \code{logical(1)} indicating if this element should
inherit the existence of an \verb{<element_blank>} among its parents. If \code{TRUE},
the existence of a blank element among its parents will cause this element
to be blank as well. If \code{FALSE}, any blank parent element will be ignored
when calculating final element state.}
}
\value{
An \verb{<element_arrow>} object that can replace \verb{<element_line>} objects
in \code{\link[ggplot2:theme]{theme()}}.
}
\description{
Using the \link[ggplot2:theme]{theme} system, draws arrows in places where
\code{\link[ggplot2:element]{element_line()}} are valid theme elements. Note
that the default use of \code{element_arrow()} does \emph{not} actually draw an arrow
unless one of the \code{arrow_} arguments is set.
}
\examples{
# Setting a bunch of arrows all over the theme
ggplot(whirlpool(5), aes(x, y, group = group)) +
  geom_path() +
  theme(
    # Proper arrow with variable width for x-axis line
    axis.line.x = element_arrow(
      arrow_head = "head_wings", linewidth_head = 2, linewidth_fins = 0
    ),
    # Just a variable width line for the y-axis line
    axis.line.y = element_arrow(linewidth_head = 0, linewidth_fins = 5,
                                lineend = "round"),
    # Arrows for the y-axis ticks
    axis.ticks.y = element_arrow(arrow_fins = arrow_head_line(angle = 45)),
    # Variable width lines for the x-axis ticks
    axis.ticks.x = element_arrow(linewidth_head = 3, linewidth_fins = 0),
    axis.ticks.length = unit(0.5, 'cm'),
    # Arrows for major panel grid
    panel.grid.major = element_arrow(
      arrow_head = "head_wings", arrow_fins = "fins_feather", length = 10
    ),
    # Shortened lines for the minor panel grid
    panel.grid.minor = element_arrow(resect = 20)
  )
}
