% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{annotate_panel}
\alias{annotate_panel}
\title{Adds custom annotations to a single panel on the ggbrain plot}
\usage{
annotate_panel(x = "middle", y = "middle", slice_index = NULL, ...)
}
\arguments{
\item{x}{the x position of the annotation. If numeric, it is assumed to be the pixel position along the x axis (e.g., 26).
In addition, convenience values of 'left', 'right', or \code{'q[1-100]'} can be used to look up the left-most, right-most, or quantile-based
positions along the x axis.}

\item{y}{the y position of the annotation. If numeric, it is assumed to be the pixel position along the y axis (e.g., 26).
In addition, convenience values of 'left', 'right', or \code{'q[1-100]'} can be used to look up the left-most, right-most, or quantile-based
positions along the x axis.}

\item{slice_index}{the slice number to which this annotation is added. These are numbered in the wrapping order from
patchwork::wrap_plots, which will normally go from top-left to bottom-right.}

\item{...}{Additional parameters passed to ggplot2::annotate such as \code{label} or \code{geom}}
}
\value{
a \code{ggb} object with the relevant annotations field and an action of "add_annotations"
}
\description{
Adds custom annotations to a single panel on the ggbrain plot
}
\details{
Note that this only handles a single annotation on a single panel!
}
