% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate Data from Structural Equation Model}
\usage{
simulate_data(
  .tdy_dag,
  b.default = NULL,
  b.lower = -0.6,
  b.upper = 0.6,
  eps = 1,
  N = 500,
  standardized = TRUE
)
}
\arguments{
\item{.tdy_dag}{the input DAG, which can be a \code{tidy_dagitty} or
\code{dagitty} object.}

\item{b.default}{default path coefficient applied to arrows for which no
coefficient is defined in the model syntax.}

\item{b.lower}{lower bound for random path coefficients, applied if b.default
= NULL.}

\item{b.upper}{upper bound for path coefficients.}

\item{eps}{residual variance (only meaningful if standardized=FALSE).}

\item{N}{number of samples to generate.}

\item{standardized}{whether a standardized output is desired (all variables
have variance 1).}
}
\value{
a \code{tbl}with N values for each variable in .tdy_dag
}
\description{
This is a thin wrapper for the \code{simulateSEM()}function in \code{dagitty}
that works with tidied dagitty objects. It treats the input DAG as a
structural equation model, generating random path coefficients and simulating
corresponding data. See \code{\link[dagitty:simulateSEM]{dagitty::simulateSEM()}} for
details.
}
\examples{
dagify(y ~ z, x ~ z) \%>\%
  tidy_dagitty() \%>\%
  simulate_data()
}
