% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_analysis.R
\name{summary.hyper}
\alias{summary.hyper}
\title{Summarise a DMC Sample with Multiple Participant at the Hyper-level}
\usage{
\method{summary}{hyper}(object, start = 1, end = NA, hyper.means = FALSE,
  ...)
}
\arguments{
\item{object}{a model samples}

\item{start}{summarise from which MCMC iteration.}

\item{end}{summarise to the end of MCMC iteration. For example, set
\code{start=101} and \code{end=1000}, instructs the function to calculate
from 101 to 1000 iteration.}

\item{hyper.means}{default as FALSE}

\item{...}{other arguments}
}
\description{
Call coda package to summarise the model parameters in a DMC samples with
multiple participants at the hyper level.
}
\examples{
m1 <- model.dmc(
     p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
     match.map = list(M=list(s1="r1",s2="r2")),
     factors   = list(S=c("s1","s2"),F=c("f1","f2")),
     constants = c(st0=0,d=0),
     responses = c("r1","r2"),
     type      = "rd")

pop.mean  <- c(a=1.15, v.f1=1.25, v.f2=1.85, z=.55,  sz=.15, sv=.32, t0=.25)
pop.scale <- c(a=.10,  v.f1=.8,   v.f2=.5,   z=0.1,  sz=.05, sv=.05, t0=.05)
pop.prior <- prior.p.dmc(
  dists = rep("tnorm", length(pop.mean)),
  p1    = pop.mean,
  p2    = pop.scale,
  lower = c(0,-5, -5, 0, 0,   0, 0),
  upper = c(5, 7,  7, 1, 0.5, 2, 2))

dat  <- h.simulate.dmc(m1, nsim=30, ns=4, p.prior=pop.prior)
mdi1 <- data.model.dmc(dat, m1)
ps   <- attr(dat,  "parameters")
### FIT RANDOM EFFECTS
p.prior <- prior.p.dmc(
  dists = c("tnorm","tnorm","tnorm","tnorm","tnorm", "tnorm", "tnorm"),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))

mu.prior <- prior.p.dmc(
  dists = c("tnorm","tnorm","tnorm","tnorm","tnorm", "tnorm", "tnorm"),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))

sigma.prior <- prior.p.dmc(
  dists = rep("beta", length(p.prior)),
  p1=c(a=1, v.f1=1,v.f2 = 1, z=1, sz=1, sv=1, t0=1),p2=c(1,1,1,1,1,1,1),
  upper=c(2,2,2,2,2, 2, 2))

pp.prior <- list(mu.prior, sigma.prior)

hsamples0 <- h.samples.dmc(nmc=30, p.prior=p.prior, pp.prior=pp.prior,
  data=mdi1, thin=1)
hsamples0 <- h.run.dmc(hsamples0, p.migrate=.05, h.p.migrate=.05)

class(hsamples0)
## [1] "hyper"

## summary.hyper calls phi.as.mcmc.list, which is very slow.
## summary(hsamples0)
## summary(hsamples0, hyper.means=TRUE)
}
\seealso{
\code{\link{summary.dmc}, \link{summary.dmc.list}}
}
\keyword{summary}

