% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dtnorm}
\alias{dtnorm}
\alias{rtnorm}
\alias{ptnorm}
\title{Truncated Normal Distribution}
\usage{
dtnorm(x, mean, sd, lower, upper, log = FALSE)

rtnorm(n, mean, sd, lower, upper)

ptnorm(q, mean, sd, lower, upper, lt = TRUE, log = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles;}

\item{mean}{mean (must be scalar).}

\item{sd}{standard deviation (must be scalar).}

\item{lower}{lower truncation value (must be scalar).}

\item{upper}{upper truncation value (must be scalar).}

\item{log}{log probability. If TRUE (default is FALSE) probabilities p are
given as \code{log(p)}.}

\item{n}{number of observations. n must be a scalar.}

\item{lt}{lower tail. If TRUE (default) probabilities are \code{P[X <= x]},
otherwise, \code{P[X > x]}.}
}
\value{
a column vector.
}
\description{
Random number generation, probability density and cumulative density
functions for truncated normal distribution.
}
\examples{
## rtn example
dat1 <- rtnorm(1e5, 0, 1, 0, Inf)
hist(dat1, breaks = "fd", freq = FALSE, xlab = "",
     main = "Truncated normal distributions")

## dtn example
x <- seq(-5, 5, length.out = 1e3)
dat1 <- dtnorm(x, 0, 1, -2, 2, 0)
plot(x, dat1, type = "l", lwd = 2, xlab = "", ylab= "Density",
     main = "Truncated normal distributions")

## ptn example
x <- seq(-50, 10, length.out = 1e3)
mean <- 0
sd <- 1
lower <- 0
upper <- 5
dat1 <- ptnorm(x, 0, 1, 0, 5, log = TRUE)
}
