% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fac2df}
\alias{fac2df}
\title{Convert factor levels to a data frame}
\usage{
fac2df(x)
}
\arguments{
\item{x}{a model object}
}
\value{
a data frame
}
\description{
\code{fac2df} takes a model object created by BuildModel and returns a
data frame with all combination of factor levels.
}
\examples{
model <- BuildModel(
 p.map     = list(a = "1", v = "1", z = "1", d = "1", sz = "1", sv = "1",
                  t0 = "1", st0 = "1"),
 constants = c(st0 = 0, d = 0),
 match.map = list(M = list(s1 = "r1",s2 = "r2")),
 factors   = list(S = c("s1","s2")),
 responses = c("r1", "r2"),
 type      = "rd")

df1 <- fac2df(model)


model <- BuildModel(
            p.map     = list(A = "1", B = "1", v = "M", sv = "M", t0 = "1",
                        st0 = "1"),
            constants = c(st0 = 0, sv.false = 1),
            match.map = list(M = list(s1 = 1, s2 = 2)),
            factors   = list(S = c("s1", "s2")),
            responses = c("r1", "r2"),
            type      = "lnorm")

fac2df(model)

model <- BuildModel(
  p.map     = list(A = "1", B = "R", t0 = "1", mean_v = c("F", "M"),
              sd_v = "M", st0 = "1"),
  match.map = list(M = list(s1 = 1, s2 = 2)),
  factors   = list(S = c("s1", "s2"), F = c("f1", "f2")),
  constants = c(sd_v.false = 1,st0 = 0),
  responses = c("r1", "r2"),
  type="norm")

fac2df(model)
##    S  F
## 1 s1 f1
## 2 s2 f1
## 3 s1 f2
## 4 s2 f2
}
