% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/themes.R
\name{plot}
\alias{plot}
\alias{plot.ggeffects}
\alias{theme_ggeffects}
\alias{show_pals}
\title{Plot ggeffects-objects}
\usage{
\method{plot}{ggeffects}(
  x,
  ci = TRUE,
  ci.style = c("ribbon", "errorbar", "dash", "dot"),
  facets,
  add.data = FALSE,
  limit.range = FALSE,
  residuals = FALSE,
  residuals.line = FALSE,
  colors = "Set1",
  alpha = 0.15,
  dodge = 0.25,
  use.theme = TRUE,
  dot.alpha = 0.35,
  jitter = 0.2,
  log.y = FALSE,
  case = NULL,
  show.legend = TRUE,
  show.title = TRUE,
  show.x.title = TRUE,
  show.y.title = TRUE,
  dot.size = NULL,
  line.size = NULL,
  connect.lines = FALSE,
  grid,
  one.plot = TRUE,
  rawdata,
  residuals.type,
  ...
)

theme_ggeffects(base_size = 11, base_family = "")

show_pals()
}
\arguments{
\item{x}{An object of class \code{ggeffects}, as returned by the functions
from this package.}

\item{ci}{Logical, if \code{TRUE}, confidence bands (for continuous variables
at x-axis) resp. error bars (for factors at x-axis) are plotted.}

\item{ci.style}{Character vector, indicating the style of the confidence
bands. May be either \code{"ribbon"}, \code{"errorbar"}, \code{"dash"} or
\code{"dot"}, to plot a ribbon, error bars, or dashed or dotted lines as
confidence bands.}

\item{facets, grid}{Logical, defaults to \code{TRUE}, if \code{x} has a column named
\code{facet}, and defaults to \code{FALSE}, if \code{x} has no such
column. Set \code{facets = TRUE} to wrap the plot into facets even
for grouping variables (see 'Examples'). \code{grid} is an alias for
\code{facets}.}

\item{add.data, rawdata}{Logical, if \code{TRUE}, a layer with raw data from response by
predictor on the x-axis, plotted as point-geoms, is added to the plot.}

\item{limit.range}{Logical, if \code{TRUE}, limits the range of the prediction
bands to the range of the data.}

\item{residuals}{Logical, if \code{TRUE}, a layer with partial residuals is
added to the plot. See vignette \href{https://cran.r-project.org/package=effects}{"Effect Displays with Partial Residuals"}
from \pkg{effects} for more details on partial residual plots.}

\item{residuals.line}{Logical, if \code{TRUE}, a loess-fit line is added to the
partial residuals plot. Only applies if \code{residuals} is \code{TRUE}.}

\item{colors}{Character vector with color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a
ggeffects-color-palette.
Following options are valid for \code{colors}:
\itemize{
  \item If not specified, the color brewer palette "Set1" will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{"bw"}, the plot is black/white and uses different line types to distinguish groups.
  \item There are some pre-defined color-palettes in this package that can be used, e.g. \code{colors = "metro"}. See \code{\link[=show_pals]{show_pals()}} to show all available palettes.
  \item Else specify own color values or names as vector (e.g. \code{colors = c("#f00000", "#00ff00")}).
}}

\item{alpha}{Alpha value for the confidence bands.}

\item{dodge}{Value for offsetting or shifting error bars, to avoid overlapping.
Only applies, if a factor is plotted at the x-axis (in such cases, the
confidence bands are replaced by error bars automatically), or if
\code{ci.style = "errorbars"}.}

\item{use.theme}{Logical, if \code{TRUE}, a slightly tweaked version of ggplot's
minimal-theme, \code{theme_ggeffects()}, is applied to the plot. If
\code{FALSE}, no theme-modifications are applied.}

\item{dot.alpha}{Alpha value for data points, when \code{add.data = TRUE}.}

\item{jitter}{Numeric, between 0 and 1. If not \code{NULL} and
\code{add.data = TRUE}, adds a small amount of random variation to
the location of data points dots, to avoid overplotting. Hence the
points don't reflect exact values in the data. May also be a numeric
vector of length two, to add different horizontal and vertical jittering.
For binary outcomes, raw data is not jittered by default to avoid that
data points exceed the axis limits.}

\item{log.y}{Logical, if \code{TRUE}, the y-axis scale is log-transformed.
This might be useful for binomial models with predicted probabilities on
the y-axis.}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{?sjlabelled::convert_case} for
more details on this argument.}

\item{show.legend}{Logical, shows or hides the plot legend.}

\item{show.title}{Logical, shows or hides the plot title-}

\item{show.x.title}{Logical, shows or hides the plot title for the x-axis.}

\item{show.y.title}{Logical, shows or hides the plot title for the y-axis.}

\item{dot.size}{Numeric, size of the point geoms.}

\item{line.size}{Numeric, size of the line geoms.}

\item{connect.lines}{Logical, if \code{TRUE} and plot has point-geoms with
error bars (this is usually the case when the x-axis is discrete), points
of same groups will be connected with a line.}

\item{one.plot}{Logical, if \code{TRUE} and \code{x} has a \code{panel} column
(i.e. when four \code{terms} were used), a single, integrated plot is produced.}

\item{residuals.type}{Deprecated. Formally was the residual type. Now is always \code{"working"}.}

\item{...}{Further arguments passed down to \code{ggplot::scale_y*()}, to
control the appearance of the y-axis.}

\item{base_size}{Base font size.}

\item{base_family}{Base font family.}
}
\value{
A ggplot2-object.
}
\description{
A generic plot-method for \code{ggeffects}-objects.
}
\details{
For proportional odds logistic regression (see \code{?MASS::polr})
  or cumulative link models in general, plots are automatically facetted
  by \code{response.level}, which indicates the grouping of predictions
  based on the level of the model's response.
}
\note{
Load \code{library(ggplot2)} and use \code{theme_set(theme_ggeffects())}
  to set the \pkg{ggeffects}-theme as default plotting theme. You can then use
  further plot-modifiers from \pkg{sjPlot}, like \code{legend_style()} or
  \code{font_size()} without losing the theme-modifications.
  \cr \cr
  There are pre-defined colour palettes in this package. Use
  \code{show_pals()} to show all available colour palettes.
}
\section{Partial Residuals}{

For \strong{generalized linear models} (glms), residualized scores are
computed as \code{inv.link(link(Y) + r)} where \code{Y} are the predicted
values on the response scale, and \code{r} are the \emph{working} residuals.
\cr\cr
For (generalized) linear \strong{mixed models}, the random effect are also
partialled out.
}

\examples{
library(sjlabelled)
data(efc)
efc$c172code <- as_label(efc$c172code)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)

dat <- ggpredict(fit, terms = "c12hour")
plot(dat)

\donttest{
# facet by group, use pre-defined color palette
dat <- ggpredict(fit, terms = c("c12hour", "c172code"))
plot(dat, facet = TRUE, colors = "hero")

# don't use facets, b/w figure, w/o confidence bands
dat <- ggpredict(fit, terms = c("c12hour", "c172code"))
plot(dat, colors = "bw", ci = FALSE)

# factor at x axis, plot exact data points and error bars
dat <- ggpredict(fit, terms = c("c172code", "c161sex"))
plot(dat)

# for three variables, automatic facetting
dat <- ggpredict(fit, terms = c("c12hour", "c172code", "c161sex"))
plot(dat)}

# show all color palettes
show_pals()

}
