% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_predictions.R
\name{test_predictions}
\alias{test_predictions}
\alias{hypothesis_test}
\alias{test_predictions.default}
\alias{test_predictions.ggeffects}
\title{(Pairwise) comparisons between predictions (marginal effects)}
\usage{
test_predictions(model, ...)

hypothesis_test(model, ...)

\method{test_predictions}{default}(
  model,
  terms = NULL,
  by = NULL,
  test = "pairwise",
  equivalence = NULL,
  scale = "response",
  p_adjust = NULL,
  df = NULL,
  ci_level = 0.95,
  collapse_levels = FALSE,
  verbose = TRUE,
  ci.lvl = ci_level,
  ...
)

\method{test_predictions}{ggeffects}(
  model,
  by = NULL,
  test = "pairwise",
  equivalence = NULL,
  scale = "response",
  p_adjust = NULL,
  df = NULL,
  collapse_levels = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A fitted model object, or an object of class \code{ggeffects}.}

\item{...}{Arguments passed down to \code{\link[=data_grid]{data_grid()}} when creating the reference
grid and to \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} resp. \code{\link[marginaleffects:slopes]{marginaleffects::slopes()}}.
For instance, arguments \code{type} or \code{transform} can be used to back-transform
comparisons and contrasts to different scales. \code{vcov} can be used to
calculate heteroscedasticity-consistent standard errors for contrasts.
See examples at the bottom of
\href{https://strengejacke.github.io/ggeffects/articles/introduction_comparisons_1.html}{this vignette}
for further details. To define a heteroscedasticity-consistent
variance-covariance matrix, you can either use the same arguments as for
\code{predict_response()} etc., namely \code{vcov_fun}, \code{vcov_type} and \code{vcov_args}.
These are then transformed into a matrix and passed down to the \code{vcov}
argument in \emph{marginaleffects}. Or you directly use the \code{vcov} argument. See
\code{?marginaleffects::slopes} for further details.}

\item{terms}{Character vector with the names of the focal terms from \code{model},
for which contrasts or comparisons should be displayed. At least one term
is required, maximum length is three terms. If the first focal term is numeric,
contrasts or comparisons for the \emph{slopes} of this numeric predictor are
computed (possibly grouped by the levels of further categorical focal
predictors).}

\item{by}{Character vector specifying the names of predictors to condition on.
Hypothesis test is then carried out for focal terms by each level of \code{by}
variables. This is useful especially for interaction terms, where we want
to test the interaction within "groups". \code{by} is only relevant for
categorical predictors.}

\item{test}{Hypothesis to test. By default, pairwise-comparisons are
conducted. See section \emph{Introduction into contrasts and pairwise comparisons}.}

\item{equivalence}{ROPE's lower and higher bounds. Should be \code{"default"} or
a vector of length two (e.g., \code{c(-0.1, 0.1)}). If \code{"default"},
\code{\link[bayestestR:rope_range]{bayestestR::rope_range()}} is used. Instead of using the \code{equivalence}
argument, it is also possible to call the \code{equivalence_test()} method
directly. This requires the \strong{parameters} package to be loaded. When
using \code{equivalence_test()}, two more columns with information about the
ROPE coverage and decision on H0 are added. Furthermore, it is possible
to \code{plot()} the results from \code{equivalence_test()}. See
\code{\link[bayestestR:equivalence_test]{bayestestR::equivalence_test()}} resp. \code{\link[parameters:equivalence_test.lm]{parameters::equivalence_test.lm()}}
for details.}

\item{scale}{Character string, indicating the scale on which the contrasts
or comparisons are represented. Can be one of:
\itemize{
\item \code{"response"} (default), which would return contrasts on the response
scale (e.g. for logistic regression, as probabilities);
\item \code{"link"} to return contrasts on scale of the linear predictors
(e.g. for logistic regression, as log-odds);
\item \code{"probability"} (or \code{"probs"}) returns contrasts on the probability scale,
which is required for some model classes, like \code{MASS::polr()};
\item \code{"oddsratios"} to return contrasts on the odds ratio scale (only applies
to logistic regression models);
\item \code{"irr"} to return contrasts on the odds ratio scale (only applies to
count models);
\item or a transformation function like \code{"exp"} or \code{"log"}, to return transformed
(exponentiated respectively logarithmic) contrasts; note that these
transformations are applied to the \emph{response scale}.
}

\strong{Note:} If the \code{scale} argument is not supported by the provided \code{model},
it is automaticaly changed to a supported scale-type (a message is printed
when \code{verbose = TRUE}).}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats:p.adjust]{stats::p.adjust()}} or \code{\link[stats:p.adjust]{stats::p.adjust.methods}}
for details. Further possible adjustment methods are \code{"tukey"} or \code{"sidak"},
and for \code{johnson_neyman()}, \code{"fdr"} (or \code{"bh"}) and \code{"esarey"} (or its
short-cut \code{"es"}) are available options. Some caution is necessary when
adjusting p-value for multiple comparisons. See also section \emph{P-value adjustment}
below.}

\item{df}{Degrees of freedom that will be used to compute the p-values and
confidence intervals. If \code{NULL}, degrees of freedom will be extracted from
the model using \code{\link[insight:get_df]{insight::get_df()}} with \code{type = "wald"}.}

\item{ci_level}{Numeric, the level of the confidence intervals.}

\item{collapse_levels}{Logical, if \code{TRUE}, term labels that refer to identical
levels are no longer separated by "-", but instead collapsed into a unique
term label (e.g., \code{"level a-level a"} becomes \code{"level a"}). See 'Examples'.}

\item{verbose}{Toggle messages and warnings.}

\item{ci.lvl}{Deprecated, please use \code{ci_level}.}
}
\value{
A data frame containing predictions (e.g. for \code{test = NULL}),
contrasts or pairwise comparisons of adjusted predictions or estimated
marginal means.
}
\description{
Function to test differences of adjusted predictions for
statistical significance. This is usually called contrasts or (pairwise)
comparisons, or "marginal effects". \code{hypothesis_test()} is an alias.
}
\section{Introduction into contrasts and pairwise comparisons}{


There are many ways to test contrasts or pairwise comparisons. A
detailed introduction with many (visual) examples is shown in
\href{https://strengejacke.github.io/ggeffects/articles/introduction_comparisons_1.html}{this vignette}.
}

\section{P-value adjustment for multiple comparisons}{


Note that p-value adjustment for methods supported by \code{p.adjust()} (see also
\code{p.adjust.methods}), each row is considered as one set of comparisons, no
matter which \code{test} was specified. That is, for instance, when \code{test_predictions()}
returns eight rows of predictions (when \code{test = NULL}), and \code{p_adjust = "bonferroni"},
the p-values are adjusted in the same way as if we had a test of pairwise
comparisons (\code{test = "pairwise"}) where eight rows of comparisons are
returned. For methods \code{"tukey"} or \code{"sidak"}, a rank adjustment is done
based on the number of combinations of levels from the focal predictors
in \code{terms}. Thus, the latter two methods may be useful for certain tests
only, in particular pairwise comparisons.

For \code{johnson_neyman()}, the only available adjustment methods are \code{"fdr"}
(or \code{"bh"}) (\emph{Benjamini & Hochberg (1995)}) and \code{"esarey"} (or \code{"es"})
(\emph{Esarey and Sumner 2017}). These usually return similar results. The major
difference is that \code{"fdr"} can be slightly faster and more stable in edge
cases, however, confidence intervals are not updated. Only the p-values are
adjusted. \code{"esarey"} is slower, but confidence intervals are updated as well.
}

\section{Global Options to Customize Tables when Printing}{

The \code{verbose} argument can be used to display or silence messages and
warnings. Furthermore, \code{options()} can be used to set defaults for the
\code{print()} and \code{print_html()} method. The following options are available,
which can simply be run in the console:
\itemize{
\item \code{ggeffects_ci_brackets}: Define a character vector of length two, indicating
the opening and closing parentheses that encompass the confidence intervals
values, e.g. \code{options(ggeffects_ci_brackets = c("[", "]"))}.
\item \code{ggeffects_collapse_ci}: Logical, if \code{TRUE}, the columns with predicted
values (or contrasts) and confidence intervals are collapsed into one
column, e.g. \code{options(ggeffects_collapse_ci = TRUE)}.
\item \code{ggeffects_collapse_p}: Logical, if \code{TRUE}, the columns with predicted
values (or contrasts) and p-values are collapsed into one column, e.g.
\code{options(ggeffects_collapse_p = TRUE)}. Note that p-values are replaced
by asterisk-symbols (stars) or empty strings when \code{ggeffects_collapse_p = TRUE},
depending on the significance level.
\item \code{ggeffects_collapse_tables}: Logical, if \code{TRUE}, multiple tables for
subgroups are combined into one table. Only works when there is more than
one focal term, e.g. \code{options(ggeffects_collapse_tables = TRUE)}.
\item \code{ggeffects_output_format}: String, either \code{"text"}, \code{"markdown"} or \code{"html"}.
Defines the default output format from \code{predict_response()}. If \code{"html"}, a
formatted HTML table is created and printed to the view pane. \code{"markdown"}
creates a markdown-formatted table inside Rmarkdown documents, and prints
a text-format table to the console when used interactively. If \code{"text"} or
\code{NULL}, a formatted table is printed to the console, e.g.
\code{options(ggeffects_output_format = "html")}.
\item \code{ggeffects_html_engine}: String, either \code{"tt"} or \code{"gt"}. Defines the default
engine to use for printing HTML tables. If \code{"tt"}, the \emph{tinytable} package
is used, if \code{"gt"}, the \emph{gt} package is used, e.g.
\code{options(ggeffects_html_engine = "gt")}.
}

Use \verb{options(<option_name> = NULL)} to remove the option.
}

\examples{
\dontshow{if (requireNamespace("marginaleffects") && requireNamespace("parameters") && requireNamespace("margins") && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(efc)
efc$c172code <- as.factor(efc$c172code)
efc$c161sex <- as.factor(efc$c161sex)
levels(efc$c161sex) <- c("male", "female")
m <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)

# direct computation of comparisons
test_predictions(m, "c172code")

# passing a `ggeffects` object
pred <- predict_response(m, "c172code")
test_predictions(pred)

# test for slope
test_predictions(m, "c12hour")

# interaction - contrasts by groups
m <- lm(barthtot ~ c12hour + c161sex * c172code + neg_c_7, data = efc)
test_predictions(m, c("c161sex", "c172code"), test = NULL)

# interaction - pairwise comparisons by groups
test_predictions(m, c("c161sex", "c172code"))

# equivalence testing
test_predictions(m, c("c161sex", "c172code"), equivalence = c(-2.96, 2.96))

# equivalence testing, using the parameters package
pr <- predict_response(m, c("c161sex", "c172code"))
parameters::equivalence_test(pr)

# interaction - collapse unique levels
test_predictions(m, c("c161sex", "c172code"), collapse_levels = TRUE)

# p-value adjustment
test_predictions(m, c("c161sex", "c172code"), p_adjust = "tukey")

# not all comparisons, only by specific group levels
test_predictions(m, "c172code", by = "c161sex")

# specific comparisons
test_predictions(m, c("c161sex", "c172code"), test = "b2 = b1")

# interaction - slope by groups
m <- lm(barthtot ~ c12hour + neg_c_7 * c172code + c161sex, data = efc)
test_predictions(m, c("neg_c_7", "c172code"))

# Example: marginal effects -----------------------------
# -------------------------------------------------------
data(iris)
m <- lm(Petal.Width ~ Petal.Length + Species, data = iris)

# we now want the marginal effects for "Species". We can calculate
# the marginal effect using the "margins" package
margins::margins(m, variables = "Species")

# we get the same marginal effect from the "marginaleffects" package
marginaleffects::avg_slopes(m, variables = "Species")

# finally, test_predictions() returns the same. while the previous results
# report the marginal effect compared to the reference level "setosa",
# test_predictions() returns the marginal effects for all pairwise comparisons
test_predictions(m, "Species")
}
\dontshow{\}) # examplesIf}
}
\references{
Esarey, J., & Sumner, J. L. (2017). Marginal effects in interaction models:
Determining and controlling the false positive rate. Comparative Political
Studies, 1–33. Advance online publication. doi: 10.1177/0010414017730080
}
\seealso{
There is also an \code{equivalence_test()} method in the \strong{parameters}
package (\code{\link[parameters:equivalence_test.lm]{parameters::equivalence_test.lm()}}), which can be used to
test contrasts or comparisons for practical equivalence. This method also
has a \code{plot()} method, hence it is possible to do something like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(parameters)
predict_response(model, focal_terms) |>
  equivalence_test() |>
  plot()
}\if{html}{\out{</div>}}
}
