% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc.R
\name{geom_arc}
\alias{geom_arc}
\alias{stat_arc}
\alias{stat_arc2}
\alias{geom_arc2}
\alias{stat_arc0}
\alias{geom_arc0}
\title{Arcs based on radius and radians}
\usage{
stat_arc(mapping = NULL, data = NULL, geom = "arc",
  position = "identity", na.rm = FALSE, show.legend = NA, n = 360,
  inherit.aes = TRUE, ...)

geom_arc(mapping = NULL, data = NULL, stat = "arc",
  position = "identity", n = 360, arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)

stat_arc2(mapping = NULL, data = NULL, geom = "path_interpolate",
  position = "identity", na.rm = FALSE, show.legend = NA, n = 360,
  inherit.aes = TRUE, ...)

geom_arc2(mapping = NULL, data = NULL, stat = "arc2",
  position = "identity", n = 360, arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)

stat_arc0(mapping = NULL, data = NULL, geom = "arc0",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

geom_arc0(mapping = NULL, data = NULL, stat = "arc0",
  position = "identity", ncp = 5, arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE}
(the default), is combined with the default mapping at the top level of the
plot. You only need to supply mapping if there isn't a mapping defined for
the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{geom, }{stat Override the default connection between \code{geom_arc} and
\code{stat_arc}.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{n}{the smoothness of the arc. Sets the number of points to use if the
arc would cover a full circle}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. borders.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here:
\itemize{
 \item{Aesthetics: to set an aesthetic to a fixed value, like
 \code{color = "red"} or \code{size = 3.}}
 \item{Other arguments to the layer, for example you override the default
 \code{stat} associated with the layer.}
 \item{Other arguments passed on to the stat.}
}}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{arrow}{specification for arrow heads, as created by arrow()}

\item{lineend}{Line end style (round, butt, square)}

\item{ncp}{the number of control points used to draw the arc with curveGrob.
Determines how well the arc approximates a circle section}
}
\description{
This set of stats and geoms makes it possible to draw circle segments based
on a centre point, a radius and a start and end angle (in radians). These
functions are intended for cartesian coordinate systems and makes it possible
to create circular plot types without using the
\code{\link[ggplot2]{coord_polar}} coordinate system.
}
\details{
An arc is a segment of a line describing a circle. It is the
fundamental visual element in donut charts where the length of the segment
(and conversely the angular span of the segment) describes the proportion of
an entety.
}
\section{Aesthetics}{

geom_arc understand the following aesthetics (required aesthetics are in
bold):
\itemize{
 \item{\strong{x0}}
 \item{\strong{y0}}
 \item{\strong{r}}
 \item{\strong{start}}
 \item{\strong{end}}
 \item{color}
 \item{size}
 \item{linetype}
 \item{alpha}
 \item{lineend}
}
}

\section{Computed variables}{


\describe{
 \item{x, y}{The start coordinates for the segment}
 \item{xend, yend}{The end coordinates for the segment}
 \item{curvature}{The curvature of the curveGrob to match a circle}
}
}

\examples{
# Lets make some data
arcs <- data.frame(
  start = seq(0, 2*pi, length.out=11)[-11],
  end = seq(0, 2*pi, length.out=11)[-1],
  r = rep(1:2, 5)
)

# Behold the arcs
ggplot() + geom_arc(aes(x0=0, y0=0, r=r, start=start, end=end,
                        linetype=factor(r)),
                    data=arcs)

}
\seealso{
\code{\link{geom_arc_bar}} for drawing arcs with fill
}
\author{
Thomas Lin Pedersen
}
