% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sina.R
\name{geom_sina}
\alias{geom_sina}
\alias{stat_sina}
\title{Sina plot}
\usage{
stat_sina(mapping = NULL, data = NULL, geom = "sina",
  position = "identity", ..., binwidth = NULL, bins = NULL,
  scale = TRUE, method = "density", maxwidth = NULL, adjust = 1,
  bin_limit = 1, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)

geom_sina(mapping = NULL, data = NULL, stat = "sina",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE}
(the default), is combined with the default mapping at the top level of the
plot. You only need to supply mapping if there isn't a mapping defined for
the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{geom, }{stat Override the default connection between \code{geom_sina}
and \code{stat_sina}.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here:
\itemize{
 \item{Aesthetics: to set an aesthetic to a fixed value, like
 \code{color = "red"} or \code{size = 3.}}
 \item{Other arguments to the layer, for example you override the default
 \code{stat} associated with the layer.}
 \item{Other arguments passed on to the stat.}
}}

\item{binwidth}{The width of the bins. The default is to use \code{bins}
bins that cover the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.}

\item{bins}{Number of bins. Overridden by binwidth. Defaults to 50.}

\item{scale}{Logical. When set to \code{TRUE} x-coordinate widths across all
groups are scaled based on the densiest area in the plot.
Default: \code{TRUE}}

\item{method}{Choose the method to spread the samples within the same
bin along the x-axis. Available methods: "density", "counts" (can be
abbreviated, e.g. "d"). See \code{Details}.}

\item{maxwidth}{Control the maximum width the points can spread into. Values
between 0 and 1.}

\item{adjust}{Adjusts the bandwidth of the density kernel when
\code{method == "density"} (see \code{\link[stats]{density}}).}

\item{bin_limit}{If the samples within the same y-axis bin are more
than \code{bin_limit}, the samples's X coordinates will be adjusted.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. borders.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}
}
\description{
The sina plot is a data visualization chart suitable for plotting any single
variable in a multiclass dataset. It is an enhanced jitter strip chart,
where the width of the jitter is controlled by the density distribution of
the data within each class.
}
\details{
There are two available ways to define the x-axis borders for the
samples to spread within:
\itemize{
 \item{\code{method == "density"}

   A density kernel is estimated along the y-axis for every sample group. The
   borders are then defined by the density curve. Tuning parameter
   \code{adjust} can be used to control the density bandwidth in the same way
   it is used in \code{\link[stats]{density}}. }

 \item{\code{method == "counts"}:

   The borders are defined by the number of samples that occupy the same bin.

  }
}
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "point")}
}

\section{Computed variables}{


\describe{
  \item{bin_counts}{sample counts per bin per group}
  \item{scaled}{adjusted x-coordinates}
}
}

\examples{
ggplot(midwest, aes(state, area)) + geom_point()

# Boxplot and Violin plots convey information on the distribution but not the
# number of samples, while Jitter does the opposite.
ggplot(midwest, aes(state, area)) + geom_violin()
ggplot(midwest, aes(state, area)) + geom_jitter()

# Sina does both!
ggplot(midwest, aes(state, area)) + geom_violin() + geom_sina()

p <- ggplot(midwest, aes(state, popdensity)) + scale_y_log10()
p + geom_sina()

# Colour the points based on the data set's columns
p + geom_sina(aes(colour = inmetro))

# Or any other way
cols <- midwest$popdensity > 10000
p + geom_sina(colour = cols + 1L)

# Sina plots with continuous x:
p <- ggplot(midwest, aes(cut_width(area, 0.02), popdensity)) + scale_y_log10()
p + geom_sina()


###Sample gaussian distributions
# Unimodal
a <- rnorm(500, 6, 1)
b <- rnorm(400, 5, 1.5)

# Bimodal
c <- c(rnorm(200, 3, .7), rnorm(50, 7, 0.4))

# Trimodal
d <- c(rnorm(200, 2, 0.7), rnorm(300, 5.5, 0.4), rnorm(100, 8, 0.4))

df <- data.frame(
  "Distribution" = c(rep("Unimodal 1", length(a)),
                     rep("Unimodal 2", length(b)),
                     rep("Bimodal", length(c)),
                     rep("Trimodal", length(d))),
  "Value" = c(a, b, c, d))

# Reorder levels
df$Distribution <- factor(df$Distribution,
                          levels(df$Distribution)[c(3, 4, 1, 2)])

p <- ggplot(df, aes(Distribution, Value))
p + geom_boxplot()
p + geom_violin() + geom_sina()

# By default, Sina plot scales the width of the class according to the width
# of the class with the highest density. Turn group-wise scaling off with:
p + geom_violin() + geom_sina(scale = FALSE)
}
\author{
Nikos Sidiropoulos
}
