% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-peel.r
\name{stat_chull}
\alias{stat_chull}
\alias{stat_peel}
\title{Convex hulls and hull peelings}
\usage{
stat_chull(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_peel(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  num = NULL,
  by = 1L,
  breaks = c(0.5),
  cut = c("above", "below"),
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{num}{A positive integer; the number of hulls to peel. Pass \code{Inf} for
all hulls.}

\item{by}{A positive integer; with what frequency to include consecutive
hulls, pairs with \code{num}.}

\item{breaks}{A numeric vector of fractions (between \code{0} and \code{1}) of the data
to contain in each hull; overridden by \code{num}.}

\item{cut}{Character; one of \code{"above"} and \code{"below"}, indicating whether each
hull should contain at least or at most \code{breaks} of the data, respectively.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Restrict planar data to the boundary points of its convex hull,
or of nested convex hulls containing specified fractions of points.
}
\details{
As used in a \strong{\link[ggplot2:ggplot2-package]{ggplot2}} vignette,
\code{stat_chull()} restricts a dataset with \code{x} and \code{y} variables to the points
that lie on its convex hull.

Building on this, \code{stat_peel()} returns hulls from a \emph{convex hull peeling}:
a subset of sequentially removed hulls containing specified fractions of
the data.
}
\section{Multidimensional position aesthetics}{

This statistical transformation is compatible with the convenience function
\code{\link[=aes_coord]{aes_coord()}}.

Some transformations (e.g. \code{\link[=stat_center]{stat_center()}}) commute with projection to the
lower (1 or 2)-dimensional biplot space. If they detect aesthetics of the
form \verb{..coord[0-9]+}, then \code{..coord1} and \code{..coord2} are converted to \code{x} and
\code{y} while any remaining are ignored.

Other transformations (e.g. \code{\link[=stat_spantree]{stat_spantree()}}) yield different results in a
lower-dimensional biplot when they are computed before versus after
projection. If the stat layer detects these aesthetics, then the
transformation is performed before projection, and the results in the first
two dimensions are returned as \code{x} and \code{y}.

A small number of transformations (\code{\link[=stat_rule]{stat_rule()}}) are incompatible with
these aesthetics but will accept \code{aes_coord()} without warning.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.
\describe{
\item{\code{hull}}{the position of \code{breaks} that defines each hull}
\item{\code{frac}}{the value of \code{breaks} that defines each hull}
\item{\code{prop}}{the actual proportion of data within each hull}
}
}

\examples{
ggplot(USJudgeRatings, aes(x = INTG, y = PREP)) +
  geom_point() +
  stat_chull(alpha = .5)
ggplot(USJudgeRatings, aes(x = INTG, y = PREP)) +
  stat_peel(
    aes(alpha = after_stat(hull)),
    breaks = seq(.1, .9, .2)
  )
ggplot(USJudgeRatings, aes(x = INTG, y = PREP)) +
  stat_peel(
    aes(alpha = after_stat(hull)),
    num = 6, by = 2, color = "black"
  )

# specify fractions of points
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  stat_peel(aes(fill = Species, alpha = after_stat(frac)),
            breaks = seq(.1, .9, .2)) +
  scale_alpha_continuous(trans = scales::reverse_trans()) +
  geom_point()
# specify number of peels
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  stat_peel(fill = "transparent", num = 3) +
  geom_point()
# mapping to opacity overrides transparency
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  stat_peel(aes(alpha = after_stat(hull)), fill = "transparent", num = 3) +
  geom_point()
}
\references{
Barnett V (1976) "The Ordering of Multivariate Data". \emph{Journal of the Royal
Statistical Society: Series A (General)}, \strong{139}(3): 318--344.
\doi{10.2307/2344839}
}
\seealso{
Other stat layers: 
\code{\link{stat_bagplot}()},
\code{\link{stat_center}()},
\code{\link{stat_cone}()},
\code{\link{stat_depth}()},
\code{\link{stat_rule}()},
\code{\link{stat_scale}()},
\code{\link{stat_spantree}()}
}
\concept{stat layers}
